% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_tools.R
\name{RGCCA_cocoreg_interface}
\alias{RGCCA_cocoreg_interface}
\title{COCOREG style analysis using RGCCA projection}
\usage{
RGCCA_cocoreg_interface(dflst, tauArr = rep(0.5, length(dflst)))
}
\arguments{
\item{dflst, }{[1,m] list of data.frames, Input data to GFA in COCOREG format}

\item{tauArr, }{[1,m] double, See RGCCA::rgcca() for details}
}
\value{
A list with elements:
\item{$data}{[1,m] list of data.frames, Original data reconstructed using only 
        those latent components that are active in all datasets}
\item{$model}{list, The output RGCCA::rgcca()}
\item{$dataid}{string, Dataset identifier string}
\item{$method}{string, Analysis method identifier string}
\item{$wall_time_taken}{[1,1] double, Time taken to run the analysis in seconds}
}
\description{
COCOREG interface used for both input and output.
}
