% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_functions.R
\name{coda_glmnet}
\alias{coda_glmnet}
\title{coda_glmnet}
\usage{
coda_glmnet(
  x,
  y,
  covar = NULL,
  lambda = "lambda.1se",
  nvar = NULL,
  alpha = 0.9,
  nfolds = 10,
  showPlots = TRUE
)
}
\arguments{
\item{x}{abundance table (rows are samples, columns are variables (taxa))}

\item{y}{outcome (binary or continuous)}

\item{covar}{data frame with covariates (default = NULL)}

\item{lambda}{penalization parameter (default = "lambda.1se")}

\item{nvar}{number of variables to use in the glmnet.fit function (default = NULL)}

\item{alpha}{elastic net parameter (default = 0.9)}

\item{nfolds}{number of folds}

\item{showPlots}{if TRUE, shows the plots (default = TRUE)}
}
\value{
if y is binary: list with "taxa.num","taxa.name","log-contrast coefficients","predictions","apparent AUC","mean cv-AUC","sd cv-AUC","predictions plot","signature plot"
if not:list with "taxa.num","taxa.name","log-contrast coefficients","predictions","apparent Rsq","mean cv-MSE","sd cv-MSE","predictions plot","signature plot"
}
\description{
Microbial signatures in cross-sectional studies.
The algorithm performs variable selection through penalized regression on the set of all pairwise log-ratios.
The result is expressed as the (weighted) balance between two groups of taxa.
It allows the use of non-compositional covariates.
}
\examples{

data(Crohn, package = "coda4microbiome")

set.seed(123)

coda_glmnet(x_Crohn[,(1:10)],y_Crohn,showPlots= FALSE)


}
\author{
M. Calle - T. Susin
}
