% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exchanges.R
\name{get_exchange_meta}
\alias{get_exchange_meta}
\title{Get all cryptocurrency exchanges metadata}
\usage{
get_exchange_meta(id = NULL, slug = NULL)
}
\arguments{
\item{id}{Alternatively pass one or more CoinMarketCap cryptocurrency IDs.
Example: c(1,2)}

\item{slug}{Alternatively pass a vector of exchange slugs.
Example: c("binance","cryptsy")}
}
\value{
A dataframe with exchange metadata values
}
\description{
Returns all static metadata for one or more exchanges.
This information includes details like launch date, logo,
official website URL, social links, and market fee documentation URL.
}
\examples{
\dontrun{
get_exchange_meta(id = 5)
get_exchange_meta(slug = c("binance", "cryptsy"))
}
}
\references{
\href{https://coinmarketcap.com/api/documentation/v1/#operation/getV1ExchangeInfo}{API documentation}
}
\seealso{
Other Exchanges: \code{\link{get_exchange_map}}
}
\concept{Exchanges}
