% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict.R
\name{Dict}
\alias{Dict}
\title{Dictionary}
\usage{
Dict(items = NULL)
}
\arguments{
\item{items}{a list of items}
}
\description{
The \code{Dict} function creates an ordinary (unordered) dictionary (a.k.a. hash).
}
\details{
Following methods are exposed:
\preformatted{
.$set(key, value)
.$get(key, default)
.$remove(key)
.$pop(key, default)
.$has(key)
.$keys()
.$values()
.$update(d)
.$clear()
.$size()
.$as_list()
.$print()
}
\itemize{
\item \code{key}: any R object, key of the item
\item \code{value}: any R object, value of the item
\item \code{default}: optional, the default value of an item if the key is not found
}
}
\examples{
d <- Dict(list(apple = 5, orange = 10))
d$set("banana", 3)
d$get("apple")
d$as_list()  # unordered
d$pop("orange")
d$as_list()  # "orange" is removed
d$set("orange", 3)$set("pear", 7)  # chain methods
}
\seealso{
\link{OrderedDict} and \link{OrderedDictL}
}
