% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_distributions.R
\name{fit_norm_trunc}
\alias{fit_norm_trunc}
\title{Find parameters that fit quantile values of an unknown truncated normal
distribution}
\usage{
fit_norm_trunc(low, high, min = 0, max = Inf)
}
\arguments{
\item{low}{5th quantile.}

\item{high}{95th quantile.}

\item{min}{Lower bound of support.}

\item{max}{Upper bound of support.}
}
\value{
Dataframe.
}
\description{
With a 5th and 95th quantile point estimates and optional lower and
upper bounds, fit a truncated normal distribution, returning the parameters of
the distribution.
}
\examples{
fit_norm_trunc(low = 10, high = 50, min = 0, max = 100)
}
\seealso{
Other distribution fitting functions: \code{\link{combine_lognorm_trunc}},
  \code{\link{combine_lognorm}},
  \code{\link{combine_norm}},
  \code{\link{fit_capabilities_geomean}},
  \code{\link{fit_capabilities}},
  \code{\link{fit_lognorm_trunc}},
  \code{\link{fit_lognorm}}, \code{\link{fit_pois}},
  \code{\link{fit_scenarios_geomean}},
  \code{\link{fit_scenarios}},
  \code{\link{fit_threat_communities}},
  \code{\link{generate_cost_function}},
  \code{\link{lognormal_to_normal}},
  \code{\link{normal_to_lognormal}}
}
\concept{distribution fitting functions}
