% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_output.R
\name{get_ambiguous_colocalization}
\alias{get_ambiguous_colocalization}
\title{Get ambiguous colocalization events from trait-specific (uncolocalized) effects.}
\source{
See detailed instructions in our tutorial portal:
\url{https://statfungen.github.io/colocboost/articles/Interpret_ColocBoost_Output.html}
}
\usage{
get_ambiguous_colocalization(
  cb_output,
  min_abs_corr_between_ucos = 0.5,
  median_abs_corr_between_ucos = 0.8,
  tol = 1e-09
)
}
\arguments{
\item{cb_output}{Output object from \code{colocboost} analysis}

\item{min_abs_corr_between_ucos}{Minimum absolute correlation for variants across two trait-specific (uncolocalized) effects to be considered colocalized. The default is 0.5.}

\item{median_abs_corr_between_ucos}{Median absolute correlation for variants across two trait-specific (uncolocalized) effects to be considered colocalized. The default is 0.8.}

\item{tol}{A small, non-negative number specifying the convergence tolerance for checking the overlap of the variables in different sets.}
}
\value{
A \code{"colocboost"} object of colocboost output with additional elements:
\item{ambiguous_cos}{If exists, a list of ambiguous trait-specific (uncolocalized) effects.}
}
\description{
\code{get_ambiguous_colocalization} get the colocalization by discarding the weaker colocalization events or colocalized outcomes
}
\examples{
data(Ambiguous_Colocalization)
test_colocboost_results <- Ambiguous_Colocalization$ColocBoost_Results
res <- get_ambiguous_colocalization(test_colocboost_results)
names(res$ambiguous_cos)

}
\seealso{
Other colocboost_inference: 
\code{\link{get_colocboost_summary}()},
\code{\link{get_robust_colocalization}()}
}
\concept{colocboost_inference}
