% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_metrics.R
\name{EMDistance}
\alias{EMDistance}
\title{Earth mover's distance between two sets of color clusters}
\usage{
EMDistance(T1, T2)
}
\arguments{
\item{T1}{Dataframe (especially a dataframe as returned by
\code{link{extractClusters}} or \code{\link{getImageHist}}, but first three
columns must be coordinates).}

\item{T2}{Another dataframe like T1.}
}
\value{
Earth mover's distance between the two dataframes (metric of overall
  bin similarity for a pair of 3-dimensional histograms).
}
\description{
Calculates the
\href{http://homepages.inf.ed.ac.uk/rbf/CVonline/LOCAL_COPIES/RUBNER/emd.htm}{Earth
mover's distance} (briefly, the amount of work required to move the data from
one distribution to resemble the other distribution, or the amount of "dirt"
you have to shovel weighted by how far you have to shovel it). Accounts for
both color disparity and size disparity. Recommended unless \code{binAvg} is
off for histogram generation.
}
\examples{
clusterList <- colordistance::getHistList(system.file("extdata",
"Heliconius/Heliconius_B", package="colordistance"), lower=rep(0.8, 3),
upper=rep(1, 3))
colordistance:::EMDistance(clusterList[[1]], clusterList[[2]])
}
