% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{average_clusters}
\alias{average_clusters}
\title{Average expression values per cluster}
\usage{
average_clusters(
  mat,
  metadata,
  cluster_col = "cluster",
  if_log = TRUE,
  cell_col = NULL,
  low_threshold = 0,
  method = "mean",
  output_log = TRUE,
  cut_n = NULL
)
}
\arguments{
\item{mat}{expression matrix}

\item{metadata}{data.frame or vector containing cluster assignments per cell.
Order must match column order in supplied matrix. If a data.frame
provide the cluster_col parameters.}

\item{cluster_col}{column in metadata with cluster number}

\item{if_log}{input data is natural log,
averaging will be done on unlogged data}

\item{cell_col}{if provided, will reorder matrix first}

\item{low_threshold}{option to remove clusters with too few cells}

\item{method}{whether to take mean (default), median, 10\% truncated mean, or trimean, max, min}

\item{output_log}{whether to report log results}

\item{cut_n}{set on a limit of genes as expressed, lower ranked genes
are set to 0, considered unexpressed}
}
\value{
average or other desired calculation by group/cluster matrix
}
\description{
Average expression values per cluster
}
