% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{scale_color_discrete_c4a_cat}
\alias{scale_color_discrete_c4a_cat}
\alias{scale_colour_discrete_c4a_cat}
\alias{scale_fill_discrete_c4a_cat}
\alias{scale_color_discrete_c4a_seq}
\alias{scale_colour_discrete_c4a_seq}
\alias{scale_fill_discrete_c4a_seq}
\alias{scale_color_discrete_c4a_div}
\alias{scale_colour_discrete_c4a_div}
\alias{scale_fill_discrete_c4a_div}
\alias{scale_color_continuous_c4a_seq}
\alias{scale_colour_continuous_c4a_seq}
\alias{scale_fill_continuous_c4a_seq}
\alias{scale_color_continuous_c4a_div}
\alias{scale_colour_continuous_c4a_div}
\alias{scale_fill_continuous_c4a_div}
\alias{scale_color_binned_c4a_seq}
\alias{scale_colour_binned_c4a_seq}
\alias{scale_fill_binned_c4a_seq}
\alias{scale_color_binned_c4a_div}
\alias{scale_colour_binned_c4a_div}
\alias{scale_fill_binned_c4a_div}
\title{col4all scales for ggplot2}
\usage{
scale_color_discrete_c4a_cat(
  palette = NULL,
  reverse = FALSE,
  order = NULL,
  ...
)

scale_colour_discrete_c4a_cat(
  palette = NULL,
  reverse = FALSE,
  order = NULL,
  ...
)

scale_fill_discrete_c4a_cat(palette = NULL, reverse = FALSE, order = NULL, ...)

scale_color_discrete_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  ...
)

scale_colour_discrete_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  ...
)

scale_fill_discrete_c4a_seq(palette = NULL, reverse = FALSE, range = NULL, ...)

scale_color_discrete_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  ...
)

scale_colour_discrete_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  ...
)

scale_fill_discrete_c4a_div(palette = NULL, reverse = FALSE, range = NULL, ...)

scale_color_continuous_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_colour_continuous_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_fill_continuous_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_color_continuous_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_colour_continuous_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_fill_continuous_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_color_binned_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_colour_binned_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_fill_binned_c4a_seq(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_color_binned_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_colour_binned_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)

scale_fill_binned_c4a_div(
  palette = NULL,
  reverse = FALSE,
  range = NULL,
  mid = 0,
  n_interp = 11,
  ...
)
}
\arguments{
\item{palette, reverse, order, range}{See \code{\link{c4a}}.}

\item{...}{parameters passed on to the underlying scale functions: \code{\link[ggplot2:discrete_scale]{discrete_scale}}, \code{\link[ggplot2:continuous_scale]{continuous_scale}}, and \code{\link[ggplot2:binned_scale]{binned_scale}}.}

\item{mid}{data value that should be mapped to the mid-point of the diverging color scale}

\item{n_interp}{number of discrete colors that should be used to interpolate the continuous color scale. Recommended to use an odd number to include the midpoint}
}
\value{
A ggplot2 component that defines the scale
}
\description{
col4all scales for ggplot2. The scale functions are organized as \verb{scale_<aesthetic>_<mapping>_c4a_<type>}, where the \verb{<aesthetic>} should be either \verb{colo(u)r} or \code{fill}, \verb{<mapping>} refers to the mapping that is applied (\code{discrete}, \code{continuous} or \code{binned}), and \verb{<type>} is the palette type: \code{cat}, \code{seq}, or \code{div}.
}
\examples{
if (require("ggplot2")) {
	data("diamonds")
	diam_exp = diamonds[diamonds$price >= 15000, ]
	diam_exp$clarity[1:500] = NA

	# discrete categorical scale
	ggplot(diam_exp, aes(x = carat, y = price, color = color)) +
		geom_point(size = 2) +
		scale_color_discrete_c4a_cat("carto.safe") +
		theme_light()

	# missing values
	c4a_plot("tol.muted", 8)
	ggplot(diam_exp, aes(x = carat, y = price, fill = clarity)) +
		geom_point(size = 2, shape = 21) +
		scale_fill_discrete_c4a_cat("tol.muted") +
		theme_light()

	# discrete sequential scale
	ggplot(diam_exp, aes(x = carat, y = price, color = cut)) +
		geom_point(size = 2) +
		scale_color_discrete_c4a_seq("hcl.blues2") +
		theme_light()

	# continuous sequential scale
	ggplot(diam_exp, aes(x = carat, y = price, color = depth)) +
		geom_point(size = 2) +
		scale_color_continuous_c4a_seq("hcl.blues2", range = c(0.4, 1)) +
		theme_light()

	# continuous diverging scale
	ggplot(diam_exp, aes(x = carat, y = depth, color = price)) +
		geom_point(size = 2) +
		scale_color_continuous_c4a_div("wes.zissou1", mid = mean(diam_exp$price)) +
		theme_light()

	# binned sequential scale
	ggplot(diam_exp, aes(x = carat, y = price, color = depth)) +
		geom_point(size = 2) +
		scale_color_binned_c4a_seq("scico.batlow", range = c(0.4, 1)) +
		theme_light()
}
}
