% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cocove.R
\name{get_cocove}
\alias{get_cocove}
\title{Create a co-located co-occurrence vector (cocove)}
\usage{
get_cocove(x, ordered = TRUE, normalization = "none")
}
\arguments{
\item{x}{A matrix - an output of the \code{\link[=get_cocoma]{get_cocoma()}} function}

\item{ordered}{The type of pairs considered.
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.}

\item{normalization}{Should the output vector be normalized?
Either "none" or "pdf".
The "pdf" option normalizes a vector to sum to one.
The default is "none".}
}
\value{
A co-located co-occurrence vector
}
\description{
Converts a co-located co-occurrence matrix (cocoma) to
a co-located co-occurrence vector (cocove)
}
\examples{
library(comat)
data(raster_x, package = "comat")
data(raster_x_na, package = "comat")

coom = get_cocoma(raster_x, raster_x_na)
coom

coov = get_cocove(coom)
coov
}
