% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icomb.R
\name{icomb}
\alias{icomb}
\alias{icombv}
\title{Combination Iterator}
\usage{
icomb(n, k)

icombv(values, k)
}
\arguments{
\item{n}{positive integer}

\item{k}{positive integer no greater than n}

\item{values}{iterable (subsettable by \code{[})}
}
\value{
iterator object
}
\description{
Create an iterator for all combinations k integers out of 1 through n.
}
\details{
\itemize{
\item{\code{icomb} iterates through integer vectors}
\item{\code{icombv} iterates through general values}
}
}
\examples{
x <- icomb(5, 3)
ct <- 0
while (hasNext(x))
{
  ct <- ct + 1
  i <- nextElem(x)
  cat(sprintf("\%3d : \%s\\n", ct, paste0(i, collapse = " ")))
}

as.list(icombv(c("A", "G", "C"), 2))
}
