% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Euclidean.R
\name{Euclidean}
\alias{Euclidean}
\title{Euclidean Numeric Comparator}
\usage{
Euclidean()
}
\value{
A \code{Euclidean} instance is returned, which is an S4 class inheriting
from \code{\link{Minkowski}}.
}
\description{
The Euclidean distance (a.k.a. L-2 distance) between two vectors \eqn{x} and
\eqn{y} is the square root of the sum of the squared differences of the
Cartesian coordinates:
\deqn{\mathrm{Euclidean}(x, y) = \sqrt{\sum_{i = 1}^{n} (x_i - y_i)^2}.}{Euclidean(x, y) = sqrt(sum_i { (x_i - y_i)^2 })}
}
\note{
The Euclidean distance is a special case of the \code{\link{Minkowski}}
distance with \eqn{p = 2}.
}
\examples{
## Distance between two vectors
x <- c(0, 1, 0, 1, 0)
y <- seq_len(5)
Euclidean()(x, y)

## Distance between rows (elementwise) of two matrices
comparator <- Euclidean()
x <- matrix(rnorm(25), nrow = 5)
y <- matrix(rnorm(5), nrow = 1)
elementwise(comparator, x, y)

## Distance between rows (pairwise) of two matrices
pairwise(comparator, x, y)

}
\seealso{
Other numeric comparators include \code{\link{Manhattan}}, \code{\link{Minkowski}} and
\code{\link{Chebyshev}}.
}
