% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnsComparison.R
\name{compare_df}
\alias{compare_df}
\title{Compare Two dataframes}
\usage{
compare_df(df_new, df_old, group_col, exclude = NULL, limit_html = 100,
  tolerance = 0)
}
\arguments{
\item{df_new}{The data frame for which any changes will be shown as an addition (green)}

\item{df_old}{The data frame for which any changes will be shown as a removal (red)}

\item{group_col}{A character vector of a string of character vector showing the columns
by which to group_by.}

\item{exclude}{The columns which should be excluded from the comparison}

\item{limit_html}{maximum number of rows to show in the html diff. >1000 not recommended}

\item{tolerance}{The amount in fraction to which changes are ignored while showing the
visual representation. By default, the value is 0 and any change in the value of variables
is shown off. Doesn't apply to categorical variables.}
}
\description{
Do a git style comparison between two data frames of similar columnar structure
}
\examples{
old_df = data.frame(var1 = c("A", "B", "C"),
                    val1 = c(1, 2, 3))
new_df = data.frame(var1 = c("A", "B", "C"),
                    val1 = c(1, 2, 4))
ctable = compare_df(new_df, old_df, c("var1"))
print(ctable$comparison_df)
ctable$html_output
}
