% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.R
\name{phi}
\alias{phi}
\title{Get the phi skew-symmetry of a sociomatrix.}
\usage{
phi(m)
}
\arguments{
\item{m}{A matrix with individuals ordered identically in rows and columns.}
}
\value{
The phi skew-symmetry index of \code{m}.
}
\description{
Get the phi skew-symmetry of a sociomatrix.
}
\section{References}{

Leiva D et al, 2008, Testing reciprocity in social interactions: A comparison between the
directional consistency and skew-symmetry statistics, Behav Res Methods.
}

\section{Further details}{

Phi is the skew-symmetry index (0 means completely symmetric, 0.5 means completely not symmetric)
}
\examples{
m <- matrix(c(NA,2,30,6,19,122,0,NA,18,
0,19,85,0,1,NA,3,8,84,0,0,0,NA,267,50,0,
0,0,5,NA,10,1,0,4,4,1,NA), ncol=6)  #table 2, Vervaecke et al. 2000  - fleeing in bonobos
phi(m)
}

