\encoding{latin1} 
\name{rec.ev.sim}
\alias{rec.ev.sim}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generate a cohort with recurrent events
}
\description{
Simulation of cohorts in a context of recurrent event survival analysis including several covariates, individual heterogeneity and periods at risk before and after the initial time of follow-up.

Recurrent event data is a type of multiple event where the subject can experience repeated occurences of the same type (Kelly, 2000), for example repeated asthma attacks or sick leave episodes. In practice, the hazard of an recurrent event can vary depending on the number of previous occurrences, in terms of shape and intensity (Reis, 2011; Navarro, 2012). However, simulations based on a mixture of distributions with different baseline hazard rates are quite rare (Bender, 2005; Metcalfe, 2006).

In a recurrent data context, each subject can present different number of episodes. We talk of episodes (or occurrences) rather than events since each occurrence is a new episode of the same event. This package supposes that there exists one different and independent \eqn{Y_k} distribution depending on \eqn{k}, the number of episode at risk. The simulating process for each \eqn{Y_k} is the same than for the multiple events situation (see \code{\link{mult.ev.sim}}), but in this case, obviously, a subject cannot be at risk for the \eqn{k}-th episode if he/she hadn't had the \eqn{k-1}-th. 
}
\usage{
rec.ev.sim(n, foltime, dist.ev, anc.ev, beta0.ev, dist.cens=rep("weibull",length(beta0.cens)), 
anc.cens, beta0.cens, z=NA, beta=NA, x=NA, lambda=NA, max.ep=Inf, priskb=0, max.old=0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{
integer value indicating the desired size of the cohort to be simulated.
}
  \item{foltime}{
real number that indicates the maximum time of follow-up of the simulated cohort.
}
  \item{dist.ev}{
vector of arbitrary size indicating the time to event distributions, with possible values \code{weibull} for the Weibull distribution, \code{lnorm} for the log-normal distribution and \code{llogistic} for the log-logistic distribution. If a subject suffers more episodes than specified distributions, the last distribution specified here is used to generate times corresponding to posterior episodes.
}
  \item{anc.ev}{
vector of arbitrary size of real components containing the ancillary parameters for the time to event distributions.
}
  \item{beta0.ev}{
vector of arbitrary size of real components containing the \eqn{\beta_0} parameters for the time to event distributions.
}
  \item{dist.cens}{
vector of arbitrary size indicating the time to censure distributions, with possible values \code{weibull} for the Weibull distribution, \code{lnorm} for the log-normal distribution and \code{llogistic} for the log-logistic distribution. If no distribution are introduced, the time to censure is assumed to follow as many different Weibull distributions as different parameters are introduced in \code{beta0.cens}.
}
  \item{anc.cens}{
vector of arbitrary size of real components containing the ancillary parameters for the time to censure distributions.
}
  \item{beta0.cens}{
vector of arbitrary size of real components containing the \eqn{\beta_0} parameters for the time to censure distributions.
}
  \item{z}{
vector with three elements that contains information relative to a random effect used in order to introduce individual heterogeneity. The first element indicates the distribution: \code{"unif"} states for the uniform distribution and \code{"normal"} states for the normal distribution. The second and third elements indicates the minimum and maximum in the case of the uniform distribution and the mean and standard deviation in the case of the normal distribution. Its default value is \code{NA}, indicating that no individual heterogeneity is introduced.
}
  \item{beta}{
list of vectors indicating the effect of the corresponding covariate. The number of vectors in \code{beta} must match the number of covariates, and the length of each vector must match the number of events considered. Its default value is NA, indicating that no covariates are included.
}
  \item{x}{
list of vectors indicating the distribution and parameters of any covariate that the user need to introduce in the simulated cohort. The possible distributions are \code{"normal"} for normal distribution, \code{"unif"} for uniform distribution and \code{"bern"} for Bernoulli distribution. Its default value is NA, indicating that no covariates are included. The number of vectors in \code{x} must match the number of vectors in \code{beta}. Each vector in \code{x} must contain the name of the distribution and the parameter(s), the probability of success in Bernoulli case, the mean and the variance for the \code{normal} distribution and the minimum and maximum in the \code{uniform} case.
}
  \item{lambda}{
real number indicating the mean duration of each event or discontinous risk time, supposed to follow a zero-truncated Poisson distribution. It's default value is \code{NA}, in the case that the duration of each event or discontinous risk time is unnecessary information for the user.
}
  \item{max.ep}{
integer value that match the maximum permitted number of episodes per subject. It's default value is Inf, corresponding to the case with no limit for the number of episodes per subject.
}
  \item{priskb}{
proportion of subjects at risk before the beginning of follow-up, defaulted to 0.
}
  \item{max.old}{
maximum time at risk before the follow-up time starts.
}
}
\details{
In order to get the function to work properly, the length of the vectors containing the parameters of the time to event and time to censure distributions and the number of distributions indicated in the parameter \code{dist} must be the same. Finally, \code{priskb} and \code{max.old} must be positive numbers, with \code{priskb} being between 0 and 1.
}
\value{
An object of class \code{sim.mult.ev.data}. It is a list where each element is a simulated subject and each row inside an element of the list is an episode suffered by the corresponding subject. The columns of each element of the list are detailed below
\item{nid }{an integer number that identifies the subject.}
\item{real.episode }{number of the episode corresponding to the real history of the individual.}
\item{obs.episode }{number of the episode corresponding to the follow-up time of the individual.}
\item{time }{time until the corresponding event happens (or time to subject drop-out), regarding the beginning of the follow-up time.}
\item{status }{logical value indicating if the episode corresponds to an event or a drop-out.}
\item{start }{time at which an episode starts, taking as origin of time scale the beginning of the follow-up.}
\item{stop }{time at which an episode ends, taking as origin of time scale the beginning of the follow-up.}
\item{time2 }{time until the corresponding event happens (or time to subject drop-out), in calendar time.}
\item{start2 }{time at which an episode starts, where the time scale is calendar time.}
\item{stop2 }{time at which an episode ends, where the time scale is calendar time.}
\item{old }{real value indicating the time that the individual has been in risk before the beginning of the follow-up.}
\item{risk.bef }{factor that indicates if an individual has been at risk before the beginning of follow-up or not.}
\item{long }{time not at risk immediately after an episode.}
\item{x}{value of each covariate randomly generated for each subject in the cohort.}
}
\references{
Kelly PJ, Lim LL. Survival analysis for recurrent event data: an application to childhood infectious diseases. Stat Med 2000 Jan 15;\bold{19}(1):13-33. 

Reis RJ, Utzet M, La Rocca PF, Nedel FB, Martin M, Navarro A. Previous sick leaves as predictor of subsequent ones. Int Arch Occup Environ Health 2011 Jun;\bold{84}(5):491-499.

Navarro A, Morina D, Reis R, Nedel FB, Martin M, Alvarado S. Hazard functions to describe patterns of new and recurrent sick leave episodes for different diagnoses. Scand J Work Environ Health 2012 Jan 27.

Bender R, Augustin T, Blettner M. Generating survival times to simulate Cox proportional hazards models. Stat Med 2005 Jun 15;\bold{24}(11):1713-1723.

Metcalfe C, Thompson SG. The importance of varying the event generation process in simulation studies of statistical methods for recurrent events. Stat Med 2006 Jan 15;\bold{25}(1):165-179.
}

\author{
David Moria, Centre Tecnolgic de Nutrici i Salut and Albert Navarro, Universitat Autnoma de Barcelona
}

\seealso{
\code{\link{complex.surv.dat.sim-package}}, \code{\link{accum}}, \code{\link{mult.ev.sim}}
}
\examples{
### A cohort with 500 subjects, with a maximum follow-up time of 1825 days and just a covariate, following a Bernoulli distribution, and a corresponding beta of -0.4, -0.5, -0.6 and -0.7 for each episode.

sim.data <- rec.ev.sim(n=500, foltime=1825, dist.ev=c('lnorm','llogistic', 'weibull','weibull'), anc.ev=c(1.498, 0.924, 0.923, 1.051),
beta0.ev=c(7.195, 6.583, 6.678, 6.430),,
anc.cens=c(1.272, 1.218, 1.341, 1.484),
beta0.cens=c(7.315, 6.975, 6.712, 6.399), z=c("unif", 0.8,1.2), beta=list(c(-0.4,-0.5,-0.6,-0.7)), x=list(c("bern", 0.5)),
lambda=c(2.18,2.33,2.40,3.46), 
priskb=0.5, max.old=730)

summary(sim.data)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ complex.surv.dat.sim }
\keyword{ individual }
\keyword{ recurrent }
\keyword{ survival }
\keyword{ simulation }