% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint-methods.R
\name{confint.bccomplmrob}
\alias{confint.bccomplmrob}
\alias{confint.bclmrob}
\title{Calculate confidence intervals}
\usage{
\method{confint}{bccomplmrob}(object, parm, level = 0.95,
  type = c("bca", "perc", "norm", "basic", "stud"), ...)

\method{confint}{bclmrob}(object, parm, level = 0.95, type = c("bca",
  "perc", "norm", "basic", "stud"), ...)
}
\arguments{
\item{object}{an object returned from \code{\link{bootcoefs}}.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector
of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{type}{the type of interval required (see the type argument of \code{\link{boot.ci}}).}

\item{...}{currently ignored.}
}
\description{
Calculate confidence intervals for bootstrapped robust linear regression estimates with or without
compositional data
}
\section{Methods (by class)}{
\itemize{
\item \code{bccomplmrob}: for bootstrapped estimates of robust linear regression models for compositional data

\item \code{bclmrob}: for bootstrapped estimates of robust linear regression models
}}

\examples{
data <- data.frame(lifeExp = state.x77[, "Life Exp"], USArrests[ , -3])
mUSArr <- complmrob(lifeExp ~ ., data = data)
bc <- bootcoefs(mUSArr, R = 200) # the number of bootstrap replicates should
                                 # normally be higher!
confint(bc, level = 0.95, type = "perc")

### For normal robust linear regression models ###
require(robustbase)
data(aircraft)

mod <- lmrob(Y ~ ., data = aircraft)
bootEst <- bootcoefs(mod, R = 200)
confint(bootEst, level = 0.95, type = "perc")
}
