% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputePermutation.R
\name{MImat2matPermu}
\alias{MImat2matPermu}
\title{Permuted Mutual Information Between Two Matrices}
\usage{
MImat2matPermu(
  mat1,
  mat2,
  bin = 6,
  sp_order = 2,
  bulkIdx = 0,
  permutationTimes = 1000,
  seedNum = 99999999
)
}
\arguments{
\item{mat1}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{mat2}{Another numeric matrix to compare against. Must have the same dimensions as `mat1`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}

\item{bulkIdx}{Index to divide the task when processing many permutations. Default is 0.}

\item{permutationTimes}{Number of permutations for sampling. Default is 1000.}

\item{seedNum}{Seed for random number generation. Default is 99999999.}
}
\value{
A numeric vector of normalized mutual information (MI) values for each permutation.
}
\description{
Computes the normalized mutual information (MI) between vectors sampled from two matrices normalized by the individual information content.
The sampling is done multiple times to generate a distribution.
}
\examples{
mat1 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
mat2 <- matrix(rnorm(10000), nrow = 100, ncol = 100)
MImat2matPermu(mat1, mat2)

}
