% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMutualInformation.R
\name{getCMIBiCondi}
\alias{getCMIBiCondi}
\title{Calculate Bivariate Conditional Mutual Information}
\usage{
getCMIBiCondi(x_1, x_2, x_3, x_4, bin = 6, sp_order = 2)
}
\arguments{
\item{x_1}{A numeric vector for the first variable.}

\item{x_2}{A numeric vector for the second variable. Must match `x_1` length.}

\item{x_3}{A numeric vector for the first condition variable. Must match `x_1` length.}

\item{x_4}{A numeric vector for the second condition variable. Must match `x_1` length.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric value representing the bivariate conditional mutual information (CMI).
}
\description{
Computes conditional mutual information I(x_1; x_2 | x_3, x_4)
using the specified number of bins and spline order.
}
\examples{
x_1 <- rnorm(100)
x_2 <- rnorm(100)
x_3 <- rnorm(100)
x_4 <- rnorm(100)
getCMIBiCondi(x_1, x_2, x_3, x_4)

}
