% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMutualInformation.R
\name{getMI}
\alias{getMI}
\title{Calculate Mutual Information Between Two Vectors}
\usage{
getMI(x_1, x_2, bin = 6, sp_order = 2)
}
\arguments{
\item{x_1}{A numeric vector representing the first variable.}

\item{x_2}{A numeric vector representing the second variable. Must be the same length as `x_1`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric value representing the mutual information (MI).
}
\description{
Computes the mutual information (MI) between two numeric vectors
using the specified number of bins and spline order.
}
\examples{
x_1 <- rnorm(100)
x_2 <- rnorm(100)
getMI(x_1, x_2)

}
