% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dem_sample.R
\name{dem_sample}
\alias{dem_sample}
\title{Randomly sample documents from a dem}
\usage{
dem_sample(x, size = NULL, replace = FALSE, weight = NULL, by = NULL)
}
\arguments{
\item{x}{a (\code{dem-class}) document-embedding-matrix}

\item{size}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>
For \code{sample_n()}, the number of rows to select.
For \code{sample_frac()}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{(numeric) Sampling weights. Vector of non-negative numbers of length \code{nrow(x)}.
Weights are automatically standardised to sum to 1 (see \code{dplyr::sample_n}).
May not be applied when \code{by} is used.}

\item{by}{(character or factor vector) either of length 1 with the name of grouping variable for sampling.
Refer to the variable WITH QUOTATIONS e.g. \code{"party"}. Must be a variable in \code{dem@docvars}. OR of length
nrow(x).}
}
\value{
a \code{size} x D (\code{dem-class}) document-embedding-matrix corresponding to the sampled
ALC embeddings. Note, \verb{@features} in the resulting object will correspond to the original \verb{@features},
that is, they are not subsetted to the sampled documents. For a list of the documents that were
sampled call the attribute: \verb{@Dimnames$docs}.
}
\description{
Take a random sample of documents from a \code{dem} with/without replacement and
with the option to group by a variable in \code{dem@docvars}.
}
\examples{

library(quanteda)

# tokenize corpus
toks <- tokens(cr_sample_corpus)

# build a tokenized corpus of contexts sorrounding a target term
immig_toks <- tokens_context(x = toks, pattern = "immigr*", window = 6L)

# build document-feature matrix
immig_dfm <- dfm(immig_toks)

# construct document-embedding-matrix
immig_dem <- dem(immig_dfm, pre_trained = cr_glove_subset,
transform = TRUE, transform_matrix = cr_transform, verbose = FALSE)

# to get a random sample
immig_wv_party <- dem_sample(immig_dem, size = 10,
replace = TRUE, by = "party")

# also works
immig_wv_party <- dem_sample(immig_dem, size = 10,
replace = TRUE, by = immig_dem@docvars$party)
}
\keyword{dem_sample}
