% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstruct.R
\name{mstruct}
\alias{mstruct}
\alias{firm}
\alias{nrs_eq}
\alias{top}
\alias{top3}
\alias{top5}
\alias{all_mstruct}
\title{Market Structure Measures}
\usage{
mstruct(x, type = c("firm", "nrs_eq", "top", "top3", "top5", "all"),
 na.rm = TRUE)

firm(x, na.rm = TRUE)

nrs_eq(x, na.rm = TRUE)

top(x, na.rm = TRUE)

top3(x, na.rm = TRUE)

top5(x, na.rm = TRUE)

all_mstruct(x, na.rm = TRUE)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{type}{A character string of the measure to be calculated,
can be abbreviated with the first letter. Defaults to "firm".}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not.}
}
\value{
returns the calculated measure
}
\description{
Set of different measures to reflect a given market structure.
}
\details{
\code{mstruct} is a wrapper for the proposed structural measures \code{firm},
returns the number of firms with a given market share, \code{nrs_eq}
computes the numbers equivalent, \code{top}, \code{top3}, and \code{top5}
calculate the share of the top (top 3 and top 5) firm(s). \code{all}
computes all measures in a one step procedure. All measures can be computed
individually.
}
\note{
the vector of market shares should be in a decimal form corresponding
to total share of individual firms/units.The sum of the vector should sum up
to 1.
}
\examples{
# a vector of market shares
share <- c(0.35, 0.4, 0.05, 0.1, 0.06, 0.04)
# the number of firms with market share
share_firm <- mstruct(share, type = "firm")
# Calculate top market share individually
share_top <- top(share)
# Calculate the market structure group measures
share_mstruct <- mstruct(share, type = "all")

}
\seealso{
{\code{\link{concstats}}, \code{\link{comp}}, \code{\link{inequ}}}
}
