% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist1.R
\name{dist1}
\alias{dist1}
\title{Minkowski distance}
\usage{
dist1(x, X, p = 2, inf = FALSE)
}
\arguments{
\item{x}{A numeric vector describing point coordinates.}

\item{X}{A numeric matrix describing coordinates for several points.}

\item{p}{The power in Minkowski distance (see details).}

\item{inf}{Logical; switch for calculating maximum norm distance (sometimes
known as Chebychev distance) which is the limit of Minkowski distance as
\eqn{p} tends to infinity.}
}
\value{
A numeric vector. These are distance^p, for speed of computation.
}
\description{
Calculate Minkowski distance between one point and a set of
  other points.
}
\examples{
x <- runif(5000)
y <- runif(5000)

x1 <- 0.5
y1 <- 0.5

dev.new(width = 4, height = 5.3)
par(mfrow = c(2, 2))

for(p in c(0.5, 1, 2, 10)){
  d <- dist1(x = c(x1, y1), X = cbind(x, y), p = p) ^ (1/p)
  col <- rep("black", length(x))
  col[d < 0.3] <- "red"
  plot(x, y, pch = 16, col = col, asp = 1, main = paste("p = ", p, sep = ""))
}
}

