% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repair_attributes.R
\name{.cstr_repair_attributes}
\alias{.cstr_repair_attributes}
\title{Repair attributes after idiomatic construction}
\usage{
.cstr_repair_attributes(
  x,
  code,
  ...,
  pipe = NULL,
  ignore = NULL,
  idiomatic_class = NULL,
  remove = NULL,
  one_liner = FALSE
)
}
\arguments{
\item{x}{The object to construct}

\item{code}{The code constructing the object before attribute reparation}

\item{...}{Forwarded to \code{.construct_apply()} when relevant}

\item{pipe}{Which pipe to use, either \code{"base"} or \code{"magrittr"}.
Defaults to \code{"base"} for R >= 4.2, otherwise to \code{"magrittr"}.}

\item{ignore}{The attributes that shouldn't be repaired, i.e. we expect them
to be set by the constructor already in \code{code}}

\item{idiomatic_class}{The class of the objects that the constructor produces,
if \code{x} is of class \code{idiomatic_class} there is no need to repair the class.}

\item{remove}{Attributes that should be removed, should rarely be useful.}

\item{one_liner}{Boolean. Whether to collapse the output to a single line of code.}
}
\value{
A character vector
}
\description{
Exported for custom constructor design. In the general case an object might have more attributes than given by the idiomatic
construction. \code{.cstr_repair_attributes()} sets some of those attributes and ignores
others.
}
