% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{templates}
\alias{templates}
\alias{.cstr_new_class}
\alias{.cstr_new_constructor}
\title{Extend constructive}
\usage{
.cstr_new_class(
  class = c("CLASS", "PARENT_CLASS"),
  constructor = "PKG::CONSTRUCTOR",
  commented = FALSE
)

.cstr_new_constructor(
  class = c("CLASS", "PARENT_CLASS"),
  constructor = "PKG::CONSTRUCTOR",
  commented = FALSE
)
}
\arguments{
\item{class}{Class to support, provide the full \code{class()} vector.}

\item{constructor}{Name of the constructor, usually the name of the function
you can to use to build the object. If not you might need to adjust the
script.}

\item{commented}{Boolean. Whether to include comments in the template.}
}
\value{
Both function return \code{NULL} invisibly and are called for side effects
}
\description{
\code{.cstr_new_class()} and \code{.cstr_new_constructor()} open new unsaved scripts,
optionally commented, that can be used as templates to define new constructors.
If the class is already supported and you want to implement a new constructor,
use \code{.cstr_new_constructor()}, otherwise use \code{.cstr_new_class()}.
}
\details{
We suggest the following workflow (summarized in a message when you call the functions):
\itemize{
\item Call \verb{usethis::use_package(\\"constructive\\"}, \"Suggests\")` one time at any
point, this will add a soft dependency on 'constructive' so it's only needed to
install it when you use it.
\item Call \code{.cstr_new_class()} or \code{.cstr_new_constructor()}, with \code{commented = TRUE} for more guidance.
\item Save the scripts unchanged in the "R" folder of your package.
\item \code{devtools::document()}: this will register the S3 methods.
\item Try \code{construct()} on your new object, it should print a call to your chosen
constructor.
\item Tweak the code, in particular the definition of \code{args}.
}

The README of the example extension package
\href{https://github.com/cynkra/constructive.example}{'constructive.example'}
guides you through the process. See also \{constructive\}'s own code
and \code{vignette("extend-constructive")} for more details.
}
