% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCoxMSM.R
\name{ctCoxMSM}
\alias{ctCoxMSM}
\title{Continuous-time Cox Marginal Structural Model}
\usage{
ctCoxMSM(data, base = NULL, td = NULL)
}
\arguments{
\item{data}{A data.frame object. A data.frame containing all observed data.
At a minimum, this data.frame must contain columns with headers 
"id", "U", "V", "deltaU", and "deltaV". If time-dependent covariates are
included, additional columns include "stop" and "start". See Details for
further information}

\item{base}{A character or integer vector or NULL. The columns of data to be
included in the time-independent component of the model. If NULL, 
time-independent covariates are excluded from the Cox model for 
treatment discontinuation.}

\item{td}{A character or integer vector or NULL. The columns of data to be
included in the time-dependent component of the model. If NULL, 
time-dependent covariates are excluded from the Cox model for treatment
discontinuation.}
}
\value{
An S3 object of class ctc. Object contains element `psi', the 
  estimate of the Cox MSM parameter(s) and `coxPH', the Cox 
  regression for V.
}
\description{
The function estimates the effect of treatment regime (in terms of time to
  treatment discontinuation) for a survival outcome under a 
  Cox proportional hazards model with time-varying confounding 
  in the presence of dependent censoring. Studying the effect of time to 
  treatment initiation is applicable by redefining 
  "treatment discontinuation" in the current description to 
  "treatment initiation".
}
\details{
The Cox marginal structural model (MSM) assumes that the potential failure 
  time \eqn{T^{\overline{a}}} 
  under the treatment \eqn{\overline{a}} follows a proportional hazards 
  model with \eqn{\psi*a_u}. We assume that the participant continuously 
  received treatment until time \eqn{V}. The observed failure time can be 
  censored assuming the censoring time is independent of the failure time 
  given the treatment and covariate history (the so-called ignorable 
  censoring). The function allows for multi-dimensional 
  baseline covariates and/or multi-dimensional time-dependent covariates.
  Variance estimates can be implemented by delete-one-group jackknifing 
  and recalling ctCoxMSM.

If only time-independent covariates are included, the data.frame must 
  contain the following columns:
  \describe{
    \item{id:}{A unique participant identifier.}
    \item{U:}{The time to the clinical event or censoring.}
    \item{deltaU:}{The clinical event indicator (1 if U is the event time;
                   0 otherwise).}
    \item{V:}{The time to optional treatment discontinuation, a clinical 
              event, censoring, or a treatment-terminating event.}
    \item{deltaV:}{The indicator of optional treatment discontinuation 
                   (1 if treatment discontinuation was optional; 0 if 
                   treatment discontinuation was due to a clinical event, 
                   censoring or a treatment-terminating event).}
  }

If time-dependent covariates are to be included, the data.frame must be
  a time-dependent dataset as described by package survival. Specifically,
  the time-dependent data must be specified for an interval (lower,upper]
  and the data must include the following additional columns:
  \describe{
     \item{start:}{The lower boundary of the time interval to which the
                   data pertain.}
     \item{stop:}{The upper boundary of the time interval to which the
                   data pertain.}
  }
}
\examples{

 data(ctcData)

 # sample data to reduce computation time of example
 smp <- ctcData$id \%in\% sample(1:1000, 150, FALSE)
 ctcData <- ctcData[smp,]

 # analysis with both time-dependent and time-independent components
 res <- ctCoxMSM(data = ctcData, base = "x", td = "xt")

 # analysis with only the time-independent component
 res <- ctCoxMSM(data = ctcData, base = "x")

 # analysis with only the time-dependent component
 res <- ctCoxMSM(data = ctcData, td = "xt")

}
\references{
Yang, S., A. A. Tsiatis, and M. Blazing (2018). 
 Modeling survival distribution as a function of time to treatment 
 discontinuation: A dynamic treatment regime approach, 
 Biometrics, 74, 900--909.
}
\seealso{
\code{\link{ctSFTM}}
}
