% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ctc.R
\name{print}
\alias{print}
\alias{print.ctc}
\title{Print the Primary Results}
\usage{
\method{print}{ctc}(x, ...)
}
\arguments{
\item{x}{An S3 object of class ctc. The value object returned by a call to 
ctCoxMSM() or ctSFTM().}

\item{...}{ignored}
}
\value{
No return value, called to display key results.
}
\description{
Print the primary results of a ctCoxMSM() or ctSFTM() analysis.
}
\examples{

 data(ctcData)

 # sample data to reduce computation time of example
 smp <- ctcData$id \%in\% sample(1:1000, 150, FALSE)
 ctcData <- ctcData[smp,]

 # analysis with both time-dependent and time-independent components
 res <- ctCoxMSM(data = ctcData, base = "x", td = "xt")

 print(x = res)

 # analysis with both time-dependent and time-independent components
 res <- ctSFTM(data = ctcData, base = "x", td = "xt")

 print(x = res)

}
