% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confine.R
\name{confine}
\alias{confine}
\title{Identify and Remove Data Points Outside of a Specified Area}
\usage{
confine(
  x,
  point.x = NULL,
  point.y = NULL,
  confinementCoord.x,
  confinementCoord.y,
  filterOutput = TRUE
)
}
\arguments{
\item{x}{Data frame or non-data-frame list that will be filtered.}

\item{point.x}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-x or 
longitude coordinate information will be used. If argument == NULL, the 
function assumes a column with the colname "x" exists in x. Defaults to 
NULL.}

\item{point.y}{Vector of length nrow(data.frame(x)) or singular character 
data, detailing the relevant colname in x, that denotes what planar-y or 
lattitude coordinate information will be used. If argument == NULL, the 
function assumes a column with the colname "y" exists in x. Defaults to 
NULL.}

\item{confinementCoord.x}{Vector describing x-coordinates of 
confining-polygon vertices. Each vertex should be described in clockwise 
or counter-clockwise order, and ordering should be consistent with 
confinementCoord.y.}

\item{confinementCoord.y}{Vector describing y-coordinates of 
confining-polygon vertices. Each vertex should be described in clockwise 
or counter-clockwise order, and ordering should be consistent with 
confinementCoord.x.}

\item{filterOutput}{Logical. If TRUE, output will be a data frame or list of
data frames (depending on whether or not x is a data frame or not) 
containing only points within confinement polygons. If FALSE, no 
observations are removed and a "confinement_status" column is appended to
x, detailing the relationship of each point to the confinement polygon. 
Defaults to TRUE.}
}
\value{
If filterOutput == TRUE, returns \code{x} less observations where
   points were located outside of the polygon defined by points in 
   \code{confinementCoord.x} and \code{confinementCoord.y}.
   
   If filterOutput == FALSE, returns \code{x} appended with a 
   "confinement_status" column which reports the results of 
   sp::point.in.polygon function, which is used to determine if observed 
   points are confined within the polygon defined by points in 
   \code{confinementCoord.x} and \code{confinementCoord.y}.
}
\description{
Identifies and removes timepoints when tracked individuals were observed 
   outside of a defined polygon (note: the polygon should be described by 
   the vectors confinementCoord.x (x coordinates) and confinementCoord.y 
   (y coordinates). These vectors must be the same length and the 
   coordinates should be listed in the clockwise or counter-clockwise 
   order that they are observed on the confining polygon.
}
\details{
If users are not actually interested in filtering datasets, but rather, 
   determining what observations should be filtered, they may set 
   filterOutput == FALSE. By doing so, this function will append a 
   "confinement_status" column to the output dataframe, which reports 
   the results of sp::point.in.polygon function that is used to determine
   if individuals are confined within a given polygon. In this column, 
   values are: 0: point is strictly exterior to pol; 1: point is strictly 
   interior to pol; 2: point lies on the relative interior of an edge of 
   pol; 3: point is a vertex of pol (see ?sp::point.in.polygon).
}
\examples{
data("calves")

water_trough.x<- c(61.43315, 61.89377, 62.37518, 61.82622) #water polygon x-coordinates
water_trough.y<- c(62.44815, 62.73341, 61.93864, 61.67411) #water polygon y-coordinates

headWater1<- confine(calves, point.x = calves$x, point.y = calves$y, 
   confinementCoord.x = water_trough.x, confinementCoord.y = water_trough.y,
   filterOutput = TRUE) #creates a data set comprised ONLY of points within the water polygon.
   
headWater2<- confine(calves, point.x = calves$x, point.y = calves$y, 
   confinementCoord.x = water_trough.x, confinementCoord.y = water_trough.y,
   filterOutput = FALSE) #appends the "confinement_status" column to x.
}
\keyword{confinement}
\keyword{filter}
\keyword{polygon}
