% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-DequeR6.R
\name{Deque}
\alias{Deque}
\title{Deque Class}
\description{
Deques are a generalization of stacks and queues typically
with methods to add, delete and access elements at both sides of the
underlying data sequence. As such, the \link{Deque} can also be used to mimic
both stacks and queues. For the standard S3 interface, see \code{\link[=deque]{deque()}}.
}
\details{
This class inherits from class \code{\link[=Container]{Container()}} and extends it by
\code{popleft} and \code{peek} methods, and reverse and rotate functionality.
}
\examples{
d = Deque$new(1, 2, s = "a", v = 1:3)
d$addleft(0)
d$peekleft()
d$peek()

d$popleft()
d$rev()

d$rotate()
d$rotate(2)
d$rotate(-3)
}
\seealso{
\code{\link[=Container]{Container()}}, \code{\link[=deque]{deque()}}
}
\section{Super classes}{
\code{\link[container:Iterable]{container::Iterable}} -> \code{\link[container:Container]{container::Container}} -> \code{Deque}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-addleft}{\code{Deque$addleft()}}
\item \href{#method-peek}{\code{Deque$peek()}}
\item \href{#method-peekleft}{\code{Deque$peekleft()}}
\item \href{#method-popleft}{\code{Deque$popleft()}}
\item \href{#method-rev}{\code{Deque$rev()}}
\item \href{#method-rotate}{\code{Deque$rotate()}}
\item \href{#method-clone}{\code{Deque$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Iterable" data-id="iter">}\href{../../container/html/Iterable.html#method-iter}{\code{container::Iterable$iter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="add">}\href{../../container/html/Container.html#method-add}{\code{container::Container$add()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at">}\href{../../container/html/Container.html#method-at}{\code{container::Container$at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="at2">}\href{../../container/html/Container.html#method-at2}{\code{container::Container$at2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="clear">}\href{../../container/html/Container.html#method-clear}{\code{container::Container$clear()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="count">}\href{../../container/html/Container.html#method-count}{\code{container::Container$count()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete">}\href{../../container/html/Container.html#method-delete}{\code{container::Container$delete()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="delete_at">}\href{../../container/html/Container.html#method-delete_at}{\code{container::Container$delete_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard">}\href{../../container/html/Container.html#method-discard}{\code{container::Container$discard()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="discard_at">}\href{../../container/html/Container.html#method-discard_at}{\code{container::Container$discard_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="empty">}\href{../../container/html/Container.html#method-empty}{\code{container::Container$empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="get_compare_fun">}\href{../../container/html/Container.html#method-get_compare_fun}{\code{container::Container$get_compare_fun()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has">}\href{../../container/html/Container.html#method-has}{\code{container::Container$has()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="has_name">}\href{../../container/html/Container.html#method-has_name}{\code{container::Container$has_name()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="initialize">}\href{../../container/html/Container.html#method-initialize}{\code{container::Container$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="is_empty">}\href{../../container/html/Container.html#method-is_empty}{\code{container::Container$is_empty()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="length">}\href{../../container/html/Container.html#method-length}{\code{container::Container$length()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="names">}\href{../../container/html/Container.html#method-names}{\code{container::Container$names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at">}\href{../../container/html/Container.html#method-peek_at}{\code{container::Container$peek_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="peek_at2">}\href{../../container/html/Container.html#method-peek_at2}{\code{container::Container$peek_at2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="pop">}\href{../../container/html/Container.html#method-pop}{\code{container::Container$pop()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="print">}\href{../../container/html/Container.html#method-print}{\code{container::Container$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="remove">}\href{../../container/html/Container.html#method-remove}{\code{container::Container$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="rename">}\href{../../container/html/Container.html#method-rename}{\code{container::Container$rename()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace">}\href{../../container/html/Container.html#method-replace}{\code{container::Container$replace()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="replace_at">}\href{../../container/html/Container.html#method-replace_at}{\code{container::Container$replace_at()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="size">}\href{../../container/html/Container.html#method-size}{\code{container::Container$size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="type">}\href{../../container/html/Container.html#method-type}{\code{container::Container$type()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="update">}\href{../../container/html/Container.html#method-update}{\code{container::Container$update()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="container" data-topic="Container" data-id="values">}\href{../../container/html/Container.html#method-values}{\code{container::Container$values()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addleft"></a>}}
\if{latex}{\out{\hypertarget{method-addleft}{}}}
\subsection{Method \code{addleft()}}{
Add element to left side of the \code{Deque}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$addleft(value, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{value of \code{ANY} type to be added to the \code{Deque}.}

\item{\code{name}}{\code{character} optional name attribute of the value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the \code{Deque} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-peek"></a>}}
\if{latex}{\out{\hypertarget{method-peek}{}}}
\subsection{Method \code{peek()}}{
Peek at last element of the \code{Deque}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$peek(default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{default}}{returned default value if \code{Deque} is empty.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
element 'peeked' on the right
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-peekleft"></a>}}
\if{latex}{\out{\hypertarget{method-peekleft}{}}}
\subsection{Method \code{peekleft()}}{
Peek at first element of the \code{Deque}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$peekleft(default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{default}}{returned default value if \code{Deque} is empty.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
element 'peeked' on the left
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-popleft"></a>}}
\if{latex}{\out{\hypertarget{method-popleft}{}}}
\subsection{Method \code{popleft()}}{
Delete and return element from the left side of the \code{\link[=Deque]{Deque()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$popleft()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
element 'popped' from the left side of the \code{\link[=Deque]{Deque()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rev"></a>}}
\if{latex}{\out{\hypertarget{method-rev}{}}}
\subsection{Method \code{rev()}}{
Reverse all elements of the \code{\link[=Deque]{Deque()}} in-place.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$rev()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the \code{Deque()} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-rotate}{}}}
\subsection{Method \code{rotate()}}{
Rotate all elements \code{n} steps to the right. If n is
negative, rotate to the left.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$rotate(n = 1L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{\code{integer} number of steps to rotate}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns the \code{Deque()} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Deque$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
