% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop.R
\name{pop}
\alias{pop}
\alias{ref_pop}
\alias{ref_popleft}
\alias{ref_pop.Deque}
\alias{ref_popleft.Deque}
\alias{ref_pop.Container}
\alias{ref_pop.dict.table}
\title{Get and Remove Element}
\usage{
ref_pop(.x, ...)

ref_popleft(.x, ...)

\method{ref_pop}{Deque}(.x, ...)

\method{ref_popleft}{Deque}(.x, ...)

\method{ref_pop}{Container}(.x, index, ...)

\method{ref_pop}{dict.table}(.x, index, ...)
}
\arguments{
\item{.x}{any \code{R} object.}

\item{...}{additional arguments to be passed to or from methods.}

\item{index}{\code{character} name or \code{numeric} position of value to be popped}
}
\value{
For \code{Deque} the first (\code{ref_popleft}) or last (\code{ref_pop}) element of
the deque after it was removed.

For \code{Container} the value at the given index after it was removed from
the \code{Container} object. If \code{index} is not found, an error is raised.

For \code{dict.table}, returns the column at the given \code{index} after it was
removed from the \code{dict.table}. If column does not exist, an error is raised.
}
\description{
Search and return an element and remove it afterwards from the object.
If the element is not found, signal an error.
}
\details{
All functions work by reference, that is, the original object is altered.
\code{ref_pop(.x)} tries to access specific values.

\code{ref_popleft(.x)} pops first element of a \code{Deque}.
}
\examples{
# Deque
d = deque(1, 2, 3)
ref_pop(d)
ref_popleft(d)

\dontrun{
ref_pop(deque())  # pop at empty Deque
}

# Container
co = container(a = 1, b = 1:3, d = "foo")
ref_pop(co, "b")
ref_pop(co, 1)

\dontrun{
ref_pop(co, "x")  # index 'x' not found
}

# dict.table
dit = dict.table(a = 1:3, b = 4:6)
ref_pop(dit, "a")
ref_pop(dit, 1)

\dontrun{
ref_pop(dit, "x")  # index 'x' not found
}
}
\seealso{
\code{\link[=peek]{peek()}}
}
