% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{Simulator}
\alias{Simulator}
\alias{run}
\alias{simulator}
\title{Simulator}
\description{
The entry point of any \pkg{contextual} simulation.
}
\details{
A Simulator takes, at a minimum, one or more \code{\link{Agent}} instances, a horizon
(the length of an individual simulation, \emph{t} = \{1, \ldots, T\}) and the number of simulations
(How many times to repeat each simulation over \emph{t} = \{1, \ldots, T\}, with a new seed
on each repeat*).

It then runs all simulations (in parallel by default), keeping a log of all \code{\link{Policy}} and
\code{\link{Bandit}} interactions in a \code{\link{History}} instance.

* Note: to be able to fairly evaluate and compare each agent's performance, and to make sure that
simulations are replicable, for each separate agent, seeds are set equally and deterministically for
each agent over all \code{horizon x simulations} time steps.

\figure{1simulator.jpeg}{contextual diagram: simulator}
}
\section{Usage}{

\preformatted{
simulator <- Simulator$new(agents,
                           horizon = 100L,
                           simulations = 100L,
                           save_context = FALSE,
                           save_theta = FALSE,
                           do_parallel = TRUE,
                           worker_max = NULL,
                           set_seed = 0,
                           save_interval = 1,
                           progress_file = FALSE,
                           log_interval = 1000,
                           include_packages = NULL,
                           t_over_sims = FALSE,
                           chunk_multiplier = 1,
                           policy_time_loop = FALSE)
}
}

\section{Arguments}{


\describe{
\item{\code{agents}}{
An \code{Agent} instance or a \code{list} of \code{Agent} instances.
}
\item{\code{horizon}}{
\code{integer}. The number of pulls or time steps to run each agent, where \emph{t} = \{1, \ldots, T\}.
}
\item{\code{simulations}}{
\code{integer}. How many times to repeat each agent's simulation over \emph{t} = \{1, \ldots, T\},
with a new seed on each repeat (itself deterministically derived from set\_seed).
}
\item{\code{save_interval}}{
\code{integer}. Write data to historyonly every \code{save_interval} time steps. Default is 1.
}
\item{\code{save_context}}{
\code{logical}. Save the context matrices \code{X} to the History log during a simulation?
}
\item{\code{save_theta}}{
\code{logical}. Save the parameter list \code{theta} to the History log during a simulation?
}
\item{\code{do_parallel}}{
\code{logical}. Run \code{Simulator} processes in parallel?
}
\item{\code{worker_max}}{
\code{integer}. Specifies how many parallel workers are to be used.
If unspecified, the amount of workers defaults to \code{max(workers_available)-1}.
}
\item{\code{t_over_sims}}{
\code{logical}. Of use to, among others, offline Bandits.
If \code{t_over_sims} is set to \code{TRUE}, the current \code{Simulator}
iterates over all rows in a data set for each repeated simulation.
If \code{FALSE}, it splits the data into \code{simulations} parts,
and a different subset of the data for each repeat of an agent's simulation.
}
\item{\code{set_seed}}{
\code{integer}. Sets the seed of R's random number generator for the current \code{Simulator}.
}
\item{\code{progress_file}}{
\code{logical}. If \code{TRUE}, \code{Simulator} writes \code{workers_progress.log},
\code{agents_progress.log} and \code{parallel.log} files to the current working directory,
allowing you to keep track of respectively \code{workers}, \code{agents},
and potential errors when running a \code{Simulator} in parallel mode.
}
\item{\code{log_interval}}{
\code{integer}. Sets the log write interval. Default every 1000 time steps.
}
\item{\code{include_packages}}{
\code{List}. List of packages that (one of) the policies depend on. If a \code{Policy} requires an
R package to be loaded, this option can be used to load that package on each of the workers.
Ignored if \code{do_parallel} is \code{FALSE}.
}
\item{\code{chunk_multiplier}}{
\code{integer} By default, simulations are equally divided over available workers, and every
worker saves its simulation results to a local history file which is then aggregated.
Depending on workload, network bandwith, memory size and other variables it can sometimes be useful to
break these workloads into smaller chunks. This can be done by setting the chunk_multiplier to some
integer value, where the number of chunks will total chunk_multiplier x number_of_workers.
}
\item{\code{policy_time_loop}}{
\code{logical} In the case of replay style bandits, a Simulator's horizon equals the number of
accepted plus the number of rejected data points or samples. If \code{policy_time_loop} is \code{TRUE},
the horizon equals the number of accepted data points or samples. That is, when \code{policy_time_loop}
is \code{TRUE}, a Simulator will keep running until the number of data points saved to History is
equal to the Simulator's horizon.
}

}
}

\section{Methods}{


\describe{

\item{\code{reset()}}{
Resets a \code{Simulator} instance to its original initialisation values.
}

\item{\code{run()}}{
Runs a \code{Simulator} instance.
}
\item{\code{history}}{
Active binding, read access to Simulator's History instance.
}

}
}

\examples{
\dontrun{

  policy    <- EpsilonGreedyPolicy$new(epsilon = 0.1)
  bandit    <- BasicBernoulliBandit$new(weights = c(0.6, 0.1, 0.1))
  agent     <- Agent$new(policy, bandit, name = "E.G.", sparse = 0.5)

  history   <- Simulator$new(agents = agent,
                             horizon = 10,
                             simulations = 10)$run()

  summary(history)

  plot(history)

  dt <- history$get_data_table()

  df <- history$get_data_frame()

  print(history$cumulative$E.G.$cum_regret_sd)

  print(history$cumulative$E.G.$cum_regret)

}

}
\seealso{
Core contextual classes: \code{\link{Bandit}}, \code{\link{Policy}}, \code{\link{Simulator}},
\code{\link{Agent}}, \code{\link{History}}, \code{\link{Plot}}

Bandit subclass examples: \code{\link{BasicBernoulliBandit}}, \code{\link{ContextualLogitBandit}},  \code{\link{OfflineReplayEvaluatorBandit}}

Policy subclass examples: \code{\link{EpsilonGreedyPolicy}}, \code{\link{ContextualLinTSPolicy}}
}
