% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KruskalWallis_asymptotic_test_rxc.R
\name{KruskalWallis_asymptotic_test_rxc}
\alias{KruskalWallis_asymptotic_test_rxc}
\title{The Kruskal-Wallis asymptotic test for singly ordered rxc tables}
\usage{
KruskalWallis_asymptotic_test_rxc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (an rxc matrix)}

\item{printresults}{display results (0 = no, 1 = yes)}
}
\value{
A list containing the two-sided p-value, the statistic and the degrees of freedom
}
\description{
The Kruskal-Wallis asymptotic test for singly ordered rxc tables

Described in Chapter 7 "The rxc Table"
}
\examples{
# Low birth weight vs psychiatric morbitidy (Table 7.6)
n <- rbind(c(22, 4, 12), c(24, 9, 10), c(51, 7, 6))
KruskalWallis_asymptotic_test_rxc(n)

# Psychiatric diag. vs BMI (Table 7.5)
n <- matrix(
  c(3, 55, 23, 8, 102, 36, 6, 14, 1, 5, 21, 12, 19, 130, 64, 7, 26, 18),
  ncol = 3, byrow = TRUE
)
KruskalWallis_asymptotic_test_rxc(n)
}
