% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilson_score_CI_1x2.R
\name{Wilson_score_CI_1x2}
\alias{Wilson_score_CI_1x2}
\title{The Wilson score confidence interval}
\usage{
Wilson_score_CI_1x2(X, n, alpha = 0.05, printresults = TRUE)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A vector containing lower, upper and point estimates of the statistic
}
\description{
The Wilson score confidence interval
}
\examples{
# birth order 1, Singh et al. (2010)
Wilson_score_CI_1x2(X=250, n=533)
# birth order 2, Singh et al. (2010)
Wilson_score_CI_1x2(X=204, n=412)
# birth order 3, Singh et al. (2010)
Wilson_score_CI_1x2(X=103, n=167)
# birth order 4, Singh et al. (2010)
Wilson_score_CI_1x2(X=33, n=45)
# Ligarden (2010)
Wilson_score_CI_1x2(X=13, n=16)
}
\references{
Reference Wilson EB (1927) Probable inference, the law of succession, and statistical inference. Journal of the American Statistical Association 22209-212
}
