% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bhapkar_test_paired_cxc.R
\name{Bhapkar_test_paired_cxc}
\alias{Bhapkar_test_paired_cxc}
\title{The Bhapkar test for marginal homogeneity}
\usage{
Bhapkar_test_paired_cxc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a cxc matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the probability, the statistic and the degrees of freedom
}
\description{
The Bhapkar test for marginal homogeneity

Described in Chapter 9 "The Paired cxc Table"
}
\examples{
# Pretherapy susceptability of pathogens (Peterson et al., 2007)
n <- rbind(c(596, 18, 6, 5), c(0, 2, 0, 0), c(0, 0, 42, 0), c(11, 0, 0, 0))
Bhapkar_test_paired_cxc(n)
}
