% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Wald_test_and_CI_marginal_mean_scores_paired_cxc.R
\name{Wald_test_and_CI_marginal_mean_scores_paired_cxc}
\alias{Wald_test_and_CI_marginal_mean_scores_paired_cxc}
\title{The Wald test and confidence interval for the difference between marginal mean scores}
\usage{
Wald_test_and_CI_marginal_mean_scores_paired_cxc(
  n,
  a,
  alpha = 0.05,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed table (a cxc matrix)}

\item{a}{scores assigned to the outcome categories}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the Wald test and the Wald CI statistics
}
\description{
The Wald test and confidence interval for the difference between marginal mean scores

Described in Chapter 9 "The Paired cxc Table"
}
\examples{
# A comparison between serial and retrospective measurements
# (Fischer et al., 1999)
n <- rbind(
  c(1, 0, 1, 0, 0),
  c(0, 2, 8, 4, 4),
  c(1, 1, 31, 14, 11),
  c(1, 0, 15, 9, 12),
  c(0, 0, 2, 1, 3)
)
a <- c(8, 3.5, 0, -3.5, -8)
Wald_test_and_CI_marginal_mean_scores_paired_cxc(n, a)
}
