% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McNemar_asymptotic_test_paired_2x2.R
\name{McNemar_asymptotic_test_paired_2x2}
\alias{McNemar_asymptotic_test_paired_2x2}
\title{The McNemar asymptotic test}
\usage{
McNemar_asymptotic_test_paired_2x2(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a 2x2 matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
The McNemar test statistic with continuity correction (\code{Z}) and the reference distribution (standard normal, \code{P})
}
\description{
The McNemar asymptotic test

Described in Chapter 8 "The Paired 2x2 Table"
}
\examples{
# Airway hyper-responsiveness before and after stem cell transplantation
# (Bentur et al., 2009)
n <- rbind(c(1, 1), c(7, 12))
McNemar_asymptotic_test_paired_2x2(n)

# Complete response before and after consolidation therapy
# (Cavo et al., 2012)
n <- rbind(c(59, 6), c(16, 80))
McNemar_asymptotic_test_paired_2x2(n)

# Floppy eyelid syndrome vs obstructive sleep apnea (Ezra et al., 2010)
n <- rbind(c(7, 25), c(2, 68))
McNemar_asymptotic_test_paired_2x2(n)

}
