
context("Gamma convergence iterated over pairs of years")
library(convergEU)
require(tibble)
require(devtools)



# debug(gamma_conv_msteps)

test_that("Basic exceptions", {

  wDF <- structure(list(time = c(2003, 2007, 2011, 2016), AT = c(7.84729051589966,
6.94676637649536, 7.65887212753296, 7.92343091964722), BE = c(7.51613569259644,
7.54294443130493, 7.37786054611206, 7.30839109420776), BG = c(4.46811723709106,
5.00835990905762, 5.5484504699707, 5.6242938041687), CY = c(7.22116661071777,
7.04802131652832, 7.16260099411011, 6.5353798866272), CZ = c(6.56695365905762,
6.59423685073853, 6.43202257156372, 6.47910213470459), DE = c(7.35872936248779,
7.16361904144287, 7.20338296890259, 7.30749416351318), DK = c(8.47181129455566,
8.47821712493896, 8.37173748016357, 8.19258117675781), EE = c(5.9371337890625,
6.72145509719849, 6.27644395828247, 6.72830581665039), EL = c(6.69278383255005,
6.58185434341431, 6.16038465499878, 5.26214599609375), ES = c(7.49084806442261,
7.25349140167236, 7.46512317657471, 6.95087099075317), FI = c(8.13736915588379,
8.23317909240723, 8.07713317871094, 8.07355976104736), FR = c(6.96316289901733,
7.32416677474976, 7.2259407043457, 7.16723203659058), HR = c(6.43675708770752,
6.43675708770752, 6.7805495262146, 6.33228302001953), HU = c(5.93741369247437,
5.59353065490723, 5.77308416366577, 6.51469230651855), IE = c(7.70209360122681,
7.58629417419434, 7.39224338531494, 7.68473958969116), IT = c(7.21626806259155,
6.58841896057129, 6.88348627090454, 6.55746126174927), LT = c(5.44309616088867,
6.32209491729736, 6.7004828453064, 6.48268938064575), LU = c(7.68836879730225,
7.90013551712036, 7.78892374038696, 7.9026083946228), LV = c(5.5742073059082,
6.03995847702026, 6.24188375473022, 6.32306814193726), MT = c(7.32220506668091,
7.55901718139648, 7.23336505889893, 7.56850624084473), NL = c(7.5457501411438,
7.86915826797485, 7.69244956970215, 7.73770427703857), PL = c(6.15987396240234,
6.89180135726929, 7.0698356628418, 7.19840478897095), PT = c(5.99070692062378,
6.18992853164673, 6.76705026626587, 6.87123918533325), RO = c(6.12324523925781,
6.47449541091919, 6.73352861404419, 6.50001859664917), SE = c(7.88903999328613,
8.33626747131348, 8.03298091888428, 7.93174123764038), SI = c(7.04277086257935,
7.22734498977661, 6.95176649093628, 6.85361623764038), SK = c(5.65658950805664,
6.67777824401855, 6.38544607162476, 6.40311002731323), UK = c(7.42172145843506,
7.28557920455933, 7.29048538208008, 7.675217628479)),
row.names = c(NA,-4L),
class = c("tbl_df", "tbl", "data.frame"))

  # debug(gamma_conv_msteps)
  resGCMS <- gamma_conv_msteps(wDF,startTime=2003,
                    endTime=2016,
                    timeName = "time")

  expect_equal(unlist(dim(resGCMS$res)), c(4,2))

  wDF[3,3] <- NA
  resGCMS <- gamma_conv_msteps(wDF,startTime=2003,
                               endTime=2016,
                               timeName = "time")
  expect_null(resGCMS$res)

  wDF <- wDF[,-(1:4)]
  resGCMS <- gamma_conv_msteps(wDF,startTime=2003,
                               endTime=2016,
                               timeName = "time")
  expect_null(resGCMS$res)

})





test_that("Basic exceptions", {

  wDF <-  dplyr::rename(emp_20_64_MS, YOUtime = time)

  # debug(gamma_conv_msteps)
  resGCMS <- gamma_conv_msteps(wDF,startTime=2003,
                               endTime=2016,
                               timeName = "time")

  expect_equal( resGCMS$err, "Error: timeName variable absent.")

  resGCMS <- gamma_conv_msteps(wDF,startTime=2003,
                               endTime=2016,
                               timeName = "YOUtime")

})



