% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_ms_fi.R
\name{go_ms_fi}
\alias{go_ms_fi}
\title{Create a country fiche for an indicator}
\usage{
go_ms_fi(
  workDF = NA,
  countryRef = NA,
  otherCountries = c(NA, NA),
  time_0 = NA,
  time_t = NA,
  tName = NA,
  indiType = NA,
  aggregation = NA,
  x_angle = NA,
  dataNow = NA,
  author = NA,
  outFile = NA,
  outDir = NA,
  indiName = NA
)
}
\arguments{
\item{workDF}{name (string) of the dataset  with all countries
contributing to average}

\item{countryRef}{country of main interest}

\item{otherCountries}{other countries for comparison}

\item{time_0}{starting time}

\item{time_t}{ending time}

\item{tName}{name of the variable containing times (years)}

\item{indiType}{type of indicator "lowBest" or "highBest"}

\item{aggregation}{label indicator the reference group of countries ('custom'
if not pre-coded)}

\item{x_angle}{axis orientation for time labels}

\item{dataNow}{date of production of this country fiche}

\item{author}{author of this report}

\item{outFile}{name of the output file (without path)}

\item{outDir}{output directory, eventualy not existing (only one level allowed)}

\item{indiName}{name of the considered indicator}
}
\description{
An auxiliary function to compile a rmarkdown file to produce a country fiche in
html format within the output directory.
}
\details{
Note that most of function arguments are passed as strings of characters
instead of object names. For example, if the object of a dataset
in the workspace is myTB, the parameter is set like  workDF='myTB'
instead of workDF=myTB as one may expect.
Furthermore, the dataset must be complete, that is without missing values.
Note also that connection to Internet should be available when invoking the
function to properly rendering the results in the html file
}
\examples{

\donttest{
go_ms_fi(
     workDF ='myTB',
     countryRef ='DE',
     otherCountries = "c('IT','UK','FR','BE','AT')",
     time_0 = 2003,
     time_t = 2014,
     tName = 'time',
     indiType = "highBest",
     aggregation= 'EU27',
     x_angle=  45,
     dataNow=  Sys.time(),
     author = 'A.Student',
     outFile = 'Counfic-DE-2015',
     outDir = 'F:/STORE/tt-fiche',
     indiName= "emp_20_64_MS"
     )

go_ms_fi(
     workDF ='myTB',
     countryRef ='IT',
     otherCountries = 'c("DE","UK")',
     time_0 = 2005,
     time_t = 2015,
     tName = 'time',
     aggregation= 'EU27',
     x_angle=  45,
     dataNow=  Sys.time(),
     author = 'A.Student',
     outFile = 'Counfic-IT-2015',
     outDir = "/tt-fish",
     indiName= "emp_20_64_MS"
     )

go_ms_fi(
     workDF ='myTB',
     countryRef ='DE',
     otherCountries = "c('IT','UK','FR','BE','AT')",
     time_0 = 2003,
     time_t = 2014,
     tName = 'time',
     indiType =  "highBest",
     aggregation= 'EU12',
     x_angle=  45,
     dataNow=  Sys.time(),
     author = 'A.Student',
     outFile = 'Counfic-DE-2015',
     outDir = '/tt-fish',
     indiName= "emp_20_64_MS"
     )

# artificially created dataset
myTTB <- emp_20_64_MS
names(myTTB)<- c("time",paste("PP",1:28,sep="-"))
go_ms_fi(
       workDF ='myTTB',
       indiName= "lifesatisf",
       countryRef ='PP-21',
       otherCountries = "c('PP-1','PP-24','PP-11','PP-28','PP-13')",
       time_0 = 2005,
       time_t = 2010,
       tName = 'time',
       indiType =  "highBest",
       aggregation= 'custom',
       x_angle=  45,
       dataNow=  Sys.time(),
       author = 'A.Student',
       outFile = 'country-test-custom',
       outDir = '/tt-fish'
     )
}

}
\references{
{\url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
