% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2D.R
\name{plot2D}
\alias{plot2D}
\title{Plots calcConv or convSig output as a two-dimensional time series.}
\usage{
plot2D(
  Ct,
  phy,
  tip,
  foc.trt,
  trait,
  pca = FALSE,
  save = FALSE,
  filename = "frame",
  dir = NULL,
  leg = FALSE,
  leg.pos = "topleft",
  width = 480,
  height = 480,
  ...
)
}
\arguments{
\item{Ct}{object containing calcConvCt or convSigCt output}

\item{phy}{The time calibrated phylogeny of interest in phylo format}

\item{tip}{vector of two tip labels indicating the putatively convergent taxa to be plotted in morphospace}

\item{foc.trt}{vector of two traits to be used in plotting. If pca == TRUE this should indicate which PC axes should be plotted in format "PC1"}

\item{trait}{the matrix of trait values used to compute Ct}

\item{pca}{logical value indicating whether to conduct principal component analysis and plot PC scores instead of raw trait values}

\item{save}{logical value indicating whether an animated time series (along with individual time slices) should be saved to a user specified folder}

\item{filename}{character indicating the desired prefix for filenames to be saved}

\item{dir}{optional character indicating the folderpath of the desired save location}

\item{leg}{logical value indicating whether a legend should be added to plots}

\item{leg.pos}{character indicating the position of the legend}

\item{width}{pixel width of saved png files}

\item{height}{pixel height of saved png files}

\item{...}{optional arguments to be passed to plot}
}
\value{
Plots tracking putatively convergent taxa in two-dimensional morphospace through time

A table with trait values, morphospace distance, and nodeheights conincident with Dmax.t. See meas.path output from calcConvCt and convSigCt
}
\description{
plot2D Plots calcConv or convSig output as a two-dimensional time series.
}
\details{
None
}
\examples{
\dontrun{
library(phytools)
library(geiger)

# create time calibrated tree
mytree<-rtree(100)
mycalibration <- makeChronosCalib(mytree, node="root", age.max=50)
phy <- chronos(mytree, lambda = 1, model = "correlated", 
calibration = mycalibration, control = chronos.control() )
class(phy)<-"phylo"

# create three normally distributed phenotypic traits
traits <- cbind(rnorm(Ntip(phy)),rnorm(Ntip(phy)),rnorm(Ntip(phy)))
colnames(traits) <- c("V1","V2","V3")
rownames(traits) <- phy$tip.label

#	select two random tips, excluding sister taxa
pairs <- apply(combn(phy$tip.label,2),2,function(x) nodepath(phy,
which(phy$tip.label == x[1]),which(phy$tip.label == x[2])))
nosis <- combn(phy$tip.label,2)[,unlist(lapply(pairs, function(x) length(x) > 3))]
focaltaxa <- nosis[,sample(1:ncol(nosis),1)]

system.time(run <- calcConvCt(phy, traits, focaltaxa))
system.time(run2 <- convSigCt(phy, traits, focaltaxa, nsim=100))

plot2D(run, phy, focaltaxa[1:2], colnames(traits)[1:2], traits)
}
}
\references{
Grossnickle DM, Brightly WH, Weaver LN, Stanchak KE, Roston RA, Pevsner SK, Stayton CT, Polly PD, Law CJ. 2022. A cautionary note on quantitative measures of phenotypic convergence. in revision
Zelditch ML, Ye J, Mitchell JS, Swiderski DL. 2017. Rare ecomorphological convergence on a complex adaptive landscape: Body size and diet mediate evolution of jaw shape in squirrels (Sciuridae). Evolution 71: 633-649
Stayton CT. 2015. The definition, recognition, and interpretation of convergent evolution and two new measures for quantifying and assessing the significance of convergence. Evolution 69(8): 2140-2153.
Revell, L. J. (2012) phytools: An R package for phylogenetic comparative biology (and other things). Methods Ecol. Evol., 3, 217-223.
Felsenstein, J. 1985. Phylogenies and the comparative method. American Naturalist, 125, 1-15.
}
