% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convoSPAT_fitpred.R
\name{predict.NSconvo}
\alias{predict.NSconvo}
\title{Obtain predictions at unobserved locations for the nonstationary
spatial model.}
\usage{
\method{predict}{NSconvo}(object, pred.coords, pred.covariates = NULL, ...)
}
\arguments{
\item{object}{A "NSconvo" object, from \code{NSconvo_fit}.}

\item{pred.coords}{Matrix of locations where predictions are required.}

\item{pred.covariates}{Matrix of covariates for the prediction locations,
NOT including an intercept. The number of columns for this matrix must
match the design matrix from \code{mean.model} in \code{\link{NSconvo_fit}}.
Defaults to an intercept only.}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
A list with the following components:
\item{pred.means}{Vector of the kriging predictor, for each location in
\code{pred.coords}.}
\item{pred.SDs}{Vector of the kriging standard errors, for each location
in \code{pred.coords}.}
}
\description{
\code{predict.NSconvo} calculates the kriging predictor and corresponding
standard errors at unmonitored sites.
}
\examples{
\dontrun{
pred.NS <- predict( NSconvo.obj,
pred.coords = matrix(c(1,1), ncol=2),
pred.covariates = matrix(c(1,1), ncol=2) )
}
}

