% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_prep.R
\name{.shiny_toJSON}
\alias{.shiny_toJSON}
\title{Prep data for javascript}
\usage{
.shiny_toJSON(
  x,
  ...,
  dataframe = "columns",
  null = "null",
  na = "null",
  auto_unbox = TRUE,
  digits = getOption("shiny.json.digits", 16),
  use_signif = TRUE,
  force = TRUE,
  POSIXt = "ISO8601",
  UTC = TRUE,
  rownames = FALSE,
  keep_vec_names = TRUE,
  strict_atomic = TRUE
)
}
\arguments{
\item{x}{the object to be encoded}

\item{...}{
  Arguments passed on to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON}}
  \describe{
    \item{\code{matrix}}{how to encode matrices and higher dimensional arrays: must be one of 'rowmajor' or 'columnmajor'.}
    \item{\code{Date}}{how to encode Date objects: must be one of 'ISO8601' or 'epoch'}
    \item{\code{factor}}{how to encode factor objects: must be one of 'string' or 'integer'}
    \item{\code{complex}}{how to encode complex numbers: must be one of 'string' or 'list'}
    \item{\code{raw}}{how to encode raw objects: must be one of 'base64', 'hex' or 'mongo'}
    \item{\code{pretty}}{adds indentation whitespace to JSON output. Can be TRUE/FALSE or a number specifying the number of spaces to indent. See \code{\link[jsonlite:prettify]{prettify()}}}
  }}

\item{dataframe}{how to encode data.frame objects: must be one of 'rows', 'columns' or 'values'}

\item{null}{how to encode NULL values within a list: must be one of 'null' or 'list'}

\item{na}{how to print NA values: must be one of 'null' or 'string'. Defaults are class specific}

\item{auto_unbox}{automatically \code{\link[jsonlite:unbox]{unbox()}} all atomic vectors of length 1. It is usually safer to avoid this and instead use the \code{\link[jsonlite:unbox]{unbox()}} function to unbox individual elements.
An exception is that objects of class \code{AsIs} (i.e. wrapped in \code{\link[=I]{I()}}) are not automatically unboxed. This is a way to mark single values as length-1 arrays.}

\item{digits}{max number of decimal digits to print for numeric values. Use \code{\link[=I]{I()}} to specify significant digits. Use \code{NA} for max precision.}

\item{use_signif}{Passed on to a print method.}

\item{force}{unclass/skip objects of classes with no defined JSON mapping}

\item{POSIXt}{how to encode POSIXt (datetime) objects: must be one of 'string', 'ISO8601', 'epoch' or 'mongo'}

\item{UTC}{Passed on to a print method.}

\item{rownames}{Passed on to a print method.}

\item{keep_vec_names}{Passed on to a print method.}

\item{strict_atomic}{Used to deal with atomic vectors and/or unboxing.}
}
\value{
Jsonified text.
}
\description{
This is an unexported function in shiny, and has been directly copy/pasted
(other than the name and documentation). This function formats things in the
way shiny's JS functions expect.
}
\keyword{internal}
