% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosmofct.R
\name{cosmofct}
\alias{cosmofct}
\title{Fast cosmology conversion functions}
\usage{
cosmofct(zmin = 0, zmax = 1, dz = 0.02, H0 = 70, OmegaM = 0.3, ...)
}
\arguments{
\item{zmin}{minimum redshift for which the conversion functions are used}

\item{zmax}{maximum redshift for which the conversion functions are used}

\item{dz}{redshift interval on which the conversion functions are interpolated (default of 0.02 is normally largely sufficient)}

\item{H0}{local Hubble constant in units of km/s/Mpc (default 70).}

\item{OmegaM}{local normalised matter density (default 0.3).}

\item{...}{other cosmological parameters accepted by \code{cosdist} of the *celestial* package. Defaults are OmegaL=1-OmegaM-OmegaR, OmegaR=0, w0=-1, wprime=0.}
}
\value{
Returns a list of 20 vectorized functions; e.g. dc2z to convert from comoving distance to redshift. Also contains the \code{age} of the universe at z=0. All distances are in units of Mpc and times are in units of Gyr.
}
\description{
Generates all 20 conversion functions between redshift (z), luminosity distance (dl), comoving distance (dc) and angular diameter distance (da), and lookback time (t = light travel time from specified redshift); based on the *celestial* package.
}
\examples{
## uses a flat LCDM cosmology with h=0.68, OmegaM=0.32 and OmegaL=0.68
cosmo = cosmofct(0,1,H0=68,OmegaM=0.32)
curve(cosmo$z2dl(x),0,1,xlab='z',ylab='distance',col='red')
curve(cosmo$z2dc(x),0,1,col='black',add=TRUE)
curve(cosmo$z2da(x),0,1,col='blue',add=TRUE)
d = seq(500,5000,500)
points(cosmo$dl2z(d),d,pch=16,col='red')
points(cosmo$dc2z(d),d,pch=16,col='black')
points(cosmo$da2z(d),d,pch=16,col='blue')

}
\author{
Danail Obreschkow (based on *celestial* package by Aaron Robotham)
}
