% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transzoom.R
\name{transzoom}
\alias{transzoom}
\title{Zoom, translate and rotate array image}
\usage{
transzoom(
  img = NULL,
  zoom = 1,
  shift = c(0, 0),
  angle = 0,
  size = NULL,
  col = "black",
  filter = "bilinear",
  file.in = "",
  file.out = "",
  format = "png",
  show.image = TRUE
)
}
\arguments{
\item{img}{n-by-m-by-3 array or n-by-m-by-4 array representing an rgb(+alpha) image.}

\item{zoom}{zoom factor (>0).}

\item{shift}{2-vector specifying the vertical+horizontal translation in units of output pixels (i.e. after zooming).}

\item{angle}{rotation angle in degrees.}

\item{size}{2-vector specifying the vertical+horizontal dimensions of the output image. If not given, this is taken to be identical to the input image.}

\item{col}{background color}

\item{filter}{affine transformation filter; either 'none' or 'bilinear'}

\item{file.in}{optional input filename, which can be used to load an image instead of providing it via \code{img}. This filename is ignored if \code{img} is specified.}

\item{file.out}{optional output filename.}

\item{format}{one of "png" or "jpg" specifying the file format of the input and output image.}

\item{show.image}{logical flag specifying whether the image is displayed in the R console.}
}
\value{
Returns an n-by-m-by-3 array or n-by-m-by-4 array of the processed image.
}
\description{
Zoom/rotate/translate an image relative to its center for images represented as simple arrays.
}
\examples{

img = yinyangyong # this is an example image included in the package
transzoom(img, zoom=2) # zoom by a factor 2

}
\author{
Danail Obreschkow
}
