% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smartround.R
\name{smartround}
\alias{smartround}
\title{Round a vector of floating-point values while preserving their sum}
\usage{
smartround(x, digits = 0)
}
\arguments{
\item{x}{vector of values}

\item{digits}{optional non-negative integer specifying the number of digits of the rounded numbers}
}
\value{
Returns a vector of rounded values of the same length as \code{x}.
}
\description{
Rounds the values in a vector up and down, preserving the sum of the vector and minimizing the total rounding error under this condition. An example where this is useful is when rounding a vector of percentages, where the total should add up to 100 percent.
}
\examples{
x = runif(5)
x = x/sum(x)*100
print(x)
print(sum(x))
y = smartround(x)
print(y)
print(sum(y))
y2 = smartround(x,2)
print(y2)
print(sum(y2))

}
\author{
Danail Obreschkow
}
