% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.r
\name{weighted}
\alias{weighted}
\title{Weighted Co-Operation}
\arguments{
\item{x}{A matrix or data.frame.}

\item{wt}{A vector of weights or scalar weight.}

\item{method}{Either "unbiased" or "ml". Unlike R, case is ignored.}
}
\description{
An optimized, efficient implemntation for computing weighted covariance,
correlation, and cosine similarity.  Similar to R's \code{cov.wt()}.
}
\details{
See \code{?coop-package} for implementation details.
}
\examples{
x <- matrix(rnorm(10*3), 10, 3)
cov.wt(x)

}
\author{
Drew Schmidt
}
\seealso{
\code{\link{cosine}}, \code{\link{pcor}}, and \code{\link{covar}}
}

