\name{copula-class}
\title{Mother Classes "Copula" and "copula" of all Copulas in the Package}
\docType{class}
\alias{copula-class}
\alias{Copula-class}
\alias{plackettCopula-class}% the only "actual" class also on this help page
\alias{dim,copula-method}
\description{
  A copula is a multivariate distribution with uniform margins.
  The virtual class \code{"Copula"} is the mother of all copula classes
  in the package \pkg{copula} which encompasses classes of the former
  packages \pkg{nacopula} and \pkg{copula}.

  The virtual class \code{"copula"} is the mother of all copula classes
  from former package \pkg{copula}.
}
\section{Objects from the Class}{
  Objects are typically created by are by \code{\link{tCopula}()},
  \code{\link{evCopula}()}, etc.

  Note that the virtual class \code{"Copula"}, is simply the union (see
  \code{\link{setClassUnion}}) of the two classes \code{"copula"} and
  \code{"\linkS4class{nacopula}"}.
}
\section{Slots}{
  Class \code{"copula"} (and all its subclasses) have slots
  \describe{
    \item{\code{dimension}:}{an \code{"integer"} (of length 1), the
      copula dimension \eqn{d}.}
    \item{\code{parameters}:}{\code{"\link{numeric}"} vector of
      parameter values, can be NA (i.e., \code{\link{NA_real_}}).}
    \item{\code{param.names}:}{\code{"character"} vector of parameter
      names (and hence of the same length as \code{parameters}).}
    \item{\code{param.lowbnd}:}{lower bounds for the parameters, of
      class \code{"numeric"}.}
    \item{\code{param.upbnd}:}{upper bounds for the parameters, of class
      \code{"numeric"}.}
    \item{\code{fullname}:}{Object of class \code{"character"}, family names
      of the copula.}
  }
}
\note{
  The \code{"copula"} class is extended by the
  \code{"\linkS4class{evCopula}"}, \code{"\linkS4class{archmCopula}"},
  and \code{"\linkS4class{ellipCopula}"} classes.  Instances of
  such copulas can be created via functions \code{\link{evCopula}},
  \code{\link{archmCopula}} and \code{\link{ellipCopula}}.

  \code{"plackettCopula"} and \code{"\linkS4class{fgmCopula}"} are
  special types of copulas which do not belong to either one of the
  three classes above.
}
\section{Warning}{
  This implementation is still at the experimental
  stage and is subject to change during the development.
}
\seealso{
  Help for the (sub)classes
  \code{\linkS4class{archmCopula}},
  \code{\linkS4class{ellipCopula}},
  \code{\linkS4class{evCopula}}, and
  \code{\linkS4class{fgmCopula}}.

  The Archimedean and nested Archimedean classes (from former package
  \pkg{nacopula}), with a more extensive list of slots (partly instead
  of methods),
  \code{\linkS4class{acopula}}, and \code{\linkS4class{nacopula}}.
}
\examples{
hc <- evCopula("husler", 1.25)
dim(hc)
smoothScatter(u <- rCopula(2^11, hc))
tailIndex   (hc)
tau (hc)
rho(hc)
str(hc)
}
\keyword{classes}
