\name{edgecutoff}
\alias{edgecutoff}
\title{Identifies Hubs
}
\description{Provides a list of traits with the most edges, identified as traits whose values are one standard deviation greater than the mean. If outliers exist, the function uses the interquartile range and median instead. Built with Cytoscape in mind, so returns the list of nodes with the most edges.
}
\usage{
edgecutoff(dat, col)
}
\arguments{
  \item{dat}{Dataset name
}
  \item{col}{Column name in the dataset that contains the edgecounts. Edgecounts can be generated by running the edgecount function first, and providing the edgecount function's output as input into edgecutoff. 
}
}
\details{This function helps to determine which traits or genes could potentially be hubs in an interaction network.

	Run edgecount first to generate the edge counts. This function uses boxplot to check for outliers and will generate a boxplot of edgecount data.
}
\value{Returns a boxplot of the edgecounts, which will be displayed in the R graphics window. Also returns a dataframe that can be exported. Column 1 is the name of the trait, with the header "Var" for variable, and column 2 is the trait's frequency, with the header "Freq."
}
\references{http://www.cytoscape.org/
	
	Krouk G, Mirowski P, LeCun Y, Shasha DE, Coruzzi GM (2010) Predictive network modeling of the high-resolution dynamic plant transcriptome in response to nitrate. Genome Biol 11(12):R123.
}
\author{Angela Fan
}
\examples{
# Create some sample data
traits <- c("Trait1", "Trait2", "Trait3", "Trait4", "Trait5")
edgecount <- c(5, 6, 7, 4, 23)
example <- cbind(traits, edgecount)

edgecutoff(example, edgecount)
# example denotes the data
# edgecount denotes the column of the data that you want to cutoff at
# returns Trait5   23 and a boxplot of the data into the graphics window
}

