% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertDir.R
\name{convertDir}
\alias{convertDir}
\title{Convert a directory of raw DICOM images to material classes}
\usage{
convertDir(directory = file.choose(), upperLim = 3045, lowerLim = -1025, 
means     = c(-850.3233, 63.912, 271.7827, 1345.0696), 
sds       = c(77.6953, 14.1728, 39.2814, 45.4129),
densities = c(0.0012, 1, 1.23, 2.2),
rootData = TRUE, 
diameter.classes = c(1, 2, 2.5, 10), 
class.names = diameter.classes,
pixel.minimum = 4)
}
\arguments{
\item{directory}{a character string that can be a matrix of DICOM images or the address of an individual DICOM file in a folder of DICOM images. The default action is <code>file.choose()</code>; a browser menu appears so the user can select the the desired directory by identifying a single DICOM file in the folder of images.}

\item{upperLim}{upper bound cutoff for pixels (Hounsfield Units)}

\item{lowerLim}{lower bound cutoff for pixels (Hounsfield Units)}

\item{means}{mean values (units = Hounsfield Units) for calibration rods used.}

\item{sds}{standard deviations (units = Hounsfield Units) for calibration rods used. Must be in the same order as \code{means}.}

\item{densities}{numeric vector of known cal rod densities. Format must be c(air, water, Si, glass)}

\item{rootData}{if TRUE, \code{rootSize} is also called on the matrix}

\item{diameter.classes}{if rootData is TRUE, this argument provides an integer vector of diameter cut points used by \code{rootSize}. Units are mm (zero is added in automatically).}

\item{class.names}{placeholder, not used presently}

\item{pixel.minimum}{minimum number of pixels needed for a clump to be identified as a root}
}
\value{
value \code{convertDir} returns a dataframe with one row per CT slice. Values returned are the area and volume of seven material classes: gas, peat, roots and rhizomes, rock and shell, fine mineral particles, sand, and water. If \code{rootData = TRUE}, the output will also contain data on the abundance (number of particles), volume (cm3), and external surface area (cm2) of the root size classes specified in the \code{diameter.classes} argument.
}
\description{
Calculates the area and volume of material classes for each CT slice in a directory. This version accommodates calibration curves with >4 calibrants, and uses density thresholds converted to Hounsfield Units using the calibration curve (rather than direct calibration rod values) to partition sediment components.
}
\details{
Calculates the area and volume of material classes for each CT slice in a directory. Unlike \code{\link{conv}}, \code{\link{convDir}} accepts a folder of raw values and makes the conversion to Hounsfield Units using the metadata associated with the DICOM images.
}
\examples{
materials <- convertDir("core_426", rootData = FALSE)


\dontrun{ 
# plot using "ggplot" package after transforming with "reshape2" package
mass.long <- reshape2::melt(materials, id.vars = c("depth"), 
   measure.vars = grep(".g", names(materials)))
ggplot2::ggplot(data = mass.long, ggplot2::aes(y = -depth, x = value, 
   color = variable)) + ggplot2::geom_point() + ggplot2::theme_classic() + 
   ggplot2::xlab("mass per section (g)") 
}

}
\seealso{
\code{\link{convertDir}} is a wrapper for \code{\link{convert}}. \code{\link{getRootsDir}} operates similarly.
}
