% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRoots.R
\name{getRoots}
\alias{getRoots}
\title{Convert a matrix of semi-processed DICOM images to root particle counts, volumes, and surface areas}
\usage{
getRoots(mat.list, pixelA, diameter.classes = c(1, 2, 2.5, 10),
class.names = diameter.classes,
thickness = 0.625,
means     = c(-850.3233, 63.912, 271.7827, 1345.0696),
sds       = c(77.6953, 14.1728, 39.2814, 45.4129), 
densities = c(0.0012, 1, 1.23, 2.2),
pixel.minimum = 4)
}
\arguments{
\item{mat.list}{list of DICOM images for a sediment core (values in Hounsfield Units)}

\item{pixelA}{pixel area (mm2)}

\item{diameter.classes}{an integer vector of diameter cut points. Units are mm (zero is added in automatically).}

\item{class.names}{not used presently}

\item{thickness}{slice thickness for computed tomography image series (mm)}

\item{means}{mean values (units = Hounsfield Units) for calibration rods used.}

\item{sds}{standard deviations (units = Hounsfield Units) for calibration rods used. Must be in the same order as \code{means}.}

\item{densities}{numeric vector of known cal rod densities. Must be in the same order as \code{means} and \code{sds}.}

\item{pixel.minimum}{minimum number of pixels needed for a clump to be identified as a root}
}
\value{
value \code{getRoots} returns a dataframe with one row per CT slice. Values returned are the number, volume (cm3), and surface area (cm2) of particles in each size class with an upper bound defined in \code{diameter.classes}.
}
\description{
Calculates the number of root/rhizome particles, volumes, and surface areas, for different size classes.  This version accommodates calibration curves with >4 calibrants, and uses density thresholds converted to Hounsfield Units using the calibration curve (rather than direct calibration rod values) to partition sediment components.
}
\details{
Calculates the number of root/rhizome particles, volumes, and surface areas, for different size classes. This function requires that values be Hounsfield Units (i.e., data must be semi-processed from the raw DICOM imagery).
}
\examples{
ct.slope <- unique(extractHeader(core_426$hdr, "RescaleSlope"))
ct.int   <- unique(extractHeader(core_426$hdr, "RescaleIntercept")) 
# convert raw units to Hounsfield units
HU_426 <- lapply(core_426$img, function(x) x*ct.slope + ct.int)

rootChars <- getRoots(HU_426, pixelA = 0.0596,
diameter.classes = c(2.5, 10))

\dontrun{
# plot using "ggplot" package after transforming with "reshape2" package
area.long <- reshape2::melt(rootChars, id.vars = c("depth"), 
   measure.vars = grep("Area", names(rootChars)))
ggplot2::ggplot(data = area.long, ggplot2::aes(y = -depth, x = value, 
   color = variable)) + ggplot2::geom_point() + ggplot2::theme_classic() + 
   ggplot2::xlab("root external surface area per slice (cm2)")
}

}
\seealso{
\code{\link{convert}}
}
