/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.pojo;

import uno.informatics.data.Dataset;
import uno.informatics.data.Study;
import uno.informatics.data.pojo.EntityPojo;
import uno.informatics.data.pojo.StudyPojo;

public class DatasetPojo
extends EntityPojo
implements Dataset {
    private static final long serialVersionUID = 1L;
    public static final String STUDY_PROPERTY = Dataset.class.getName() + ".study";
    public static final String SIZE_PROPERTY = Dataset.class.getName() + ".size";
    private StudyPojo study;
    private int size;

    public DatasetPojo(String name) {
        super(name);
    }

    public DatasetPojo(String uniqueIdentifier, String name) {
        super(uniqueIdentifier, name);
    }

    public DatasetPojo(String uniqueIdentifier, String name, String description) {
        super(uniqueIdentifier, name, description);
    }

    public DatasetPojo(Dataset dataset) {
        super(dataset);
        if (dataset == null) {
            throw new IllegalArgumentException("Data is not optional!");
        }
        this.setStudy(dataset.getStudy());
        this.setSize(dataset.getSize());
    }

    @Override
    public Study getStudy() {
        return this.study;
    }

    public final void setStudy(Study study) {
        StudyPojo oldValue = this.study;
        this.study = study != null ? new StudyPojo(study) : null;
        this.getPropertyChangeSupport().firePropertyChange(STUDY_PROPERTY, oldValue, this.study);
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    public final void setSize(int size) {
        if (size != this.size) {
            int oldValue = this.size;
            this.size = size;
            this.getPropertyChangeSupport().firePropertyChange(SIZE_PROPERTY, oldValue, this.size);
        }
    }
}

