/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.problems.objectives.evaluations;

import java.util.HashMap;
import java.util.Map;
import org.jamesframework.core.problems.constraints.validations.PenalizingValidation;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;

public class PenalizedEvaluation
implements Evaluation {
    private final Evaluation evaluation;
    private Map<Object, PenalizingValidation> penalties;
    private final boolean minimizing;
    private double penalizedValue;
    private boolean assignedPenalties;

    public PenalizedEvaluation(Evaluation evaluation, boolean minimizing) {
        this.evaluation = evaluation;
        this.minimizing = minimizing;
        this.penalties = null;
        this.penalizedValue = evaluation.getValue();
        this.assignedPenalties = false;
    }

    private void initMapOnce() {
        if (this.penalties == null) {
            this.penalties = new HashMap<Object, PenalizingValidation>();
        }
    }

    public void addPenalizingValidation(Object key, PenalizingValidation penalizingValidation) {
        this.initMapOnce();
        this.penalties.put(key, penalizingValidation);
        if (!penalizingValidation.passed()) {
            this.assignedPenalties = true;
            double p = penalizingValidation.getPenalty();
            this.penalizedValue += this.minimizing ? p : -p;
        }
    }

    public PenalizingValidation getPenalizingValidation(Object key) {
        return this.penalties == null ? null : this.penalties.get(key);
    }

    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    @Override
    public double getValue() {
        return this.penalizedValue;
    }

    public String toString() {
        if (!this.assignedPenalties) {
            return this.getValue() + "";
        }
        return this.getValue() + " (unpenalized: " + this.getEvaluation().getValue() + ")";
    }
}

